/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ConversationMember;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ConversationMemberCollectionPage;
import com.microsoft.graph.requests.extensions.ConversationMemberCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ConversationMemberCollectionResponse;
import com.microsoft.graph.requests.extensions.ConversationMemberRequestBuilder;
import com.microsoft.graph.requests.extensions.IConversationMemberCollectionPage;
import com.microsoft.graph.requests.extensions.IConversationMemberCollectionRequest;
import java.util.List;

public class ConversationMemberCollectionRequest
extends BaseCollectionRequest<ConversationMemberCollectionResponse, IConversationMemberCollectionPage>
implements IConversationMemberCollectionRequest {
    public ConversationMemberCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConversationMemberCollectionResponse.class, IConversationMemberCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IConversationMemberCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ConversationMemberCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IConversationMemberCollectionPage get() throws ClientException {
        ConversationMemberCollectionResponse response = (ConversationMemberCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ConversationMember newConversationMember, ICallback<ConversationMember> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ConversationMemberRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newConversationMember, callback);
    }

    @Override
    public ConversationMember post(ConversationMember newConversationMember) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ConversationMemberRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newConversationMember);
    }

    @Override
    public IConversationMemberCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IConversationMemberCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IConversationMemberCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IConversationMemberCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IConversationMemberCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IConversationMemberCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IConversationMemberCollectionPage buildFromResponse(ConversationMemberCollectionResponse response) {
        ConversationMemberCollectionRequestBuilder builder = response.nextLink != null ? new ConversationMemberCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ConversationMemberCollectionPage page = new ConversationMemberCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

