/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.DriveItemCreateLinkBody;
import com.microsoft.graph.models.extensions.Permission;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IDriveItemCreateLinkRequest;
import java.util.List;

public class DriveItemCreateLinkRequest
extends BaseRequest
implements IDriveItemCreateLinkRequest {
    protected final DriveItemCreateLinkBody body = new DriveItemCreateLinkBody();

    public DriveItemCreateLinkRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, Permission.class);
    }

    @Override
    public void post(ICallback<Permission> callback) {
        this.send(HttpMethod.POST, callback, this.body);
    }

    @Override
    public Permission post() throws ClientException {
        return (Permission)this.send(HttpMethod.POST, this.body);
    }

    @Override
    public IDriveItemCreateLinkRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemCreateLinkRequest top(int value) {
        this.getQueryOptions().add(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveItemCreateLinkRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IDriveItemCreateLinkRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

