/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DriveItemVersion;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DriveItemVersionCollectionPage;
import com.microsoft.graph.requests.extensions.DriveItemVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemVersionCollectionResponse;
import com.microsoft.graph.requests.extensions.DriveItemVersionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemVersionCollectionPage;
import com.microsoft.graph.requests.extensions.IDriveItemVersionCollectionRequest;
import java.util.List;

public class DriveItemVersionCollectionRequest
extends BaseCollectionRequest<DriveItemVersionCollectionResponse, IDriveItemVersionCollectionPage>
implements IDriveItemVersionCollectionRequest {
    public DriveItemVersionCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DriveItemVersionCollectionResponse.class, IDriveItemVersionCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDriveItemVersionCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DriveItemVersionCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDriveItemVersionCollectionPage get() throws ClientException {
        DriveItemVersionCollectionResponse response = (DriveItemVersionCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DriveItemVersion newDriveItemVersion, ICallback<DriveItemVersion> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DriveItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDriveItemVersion, callback);
    }

    @Override
    public DriveItemVersion post(DriveItemVersion newDriveItemVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DriveItemVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDriveItemVersion);
    }

    @Override
    public IDriveItemVersionCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDriveItemVersionCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IDriveItemVersionCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDriveItemVersionCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDriveItemVersionCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDriveItemVersionCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDriveItemVersionCollectionPage buildFromResponse(DriveItemVersionCollectionResponse response) {
        DriveItemVersionCollectionRequestBuilder builder = response.nextLink != null ? new DriveItemVersionCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DriveItemVersionCollectionPage page = new DriveItemVersionCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

