/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.ItemAttachment;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IItemAttachmentRequest;
import java.util.List;

public class ItemAttachmentRequest
extends BaseRequest
implements IItemAttachmentRequest {
    public ItemAttachmentRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemAttachment.class);
    }

    @Override
    public void get(ICallback<ItemAttachment> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public ItemAttachment get() throws ClientException {
        return (ItemAttachment)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<ItemAttachment> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(ItemAttachment sourceItemAttachment, ICallback<ItemAttachment> callback) {
        this.send(HttpMethod.PATCH, callback, sourceItemAttachment);
    }

    @Override
    public ItemAttachment patch(ItemAttachment sourceItemAttachment) throws ClientException {
        return (ItemAttachment)this.send(HttpMethod.PATCH, sourceItemAttachment);
    }

    @Override
    public void post(ItemAttachment newItemAttachment, ICallback<ItemAttachment> callback) {
        this.send(HttpMethod.POST, callback, newItemAttachment);
    }

    @Override
    public ItemAttachment post(ItemAttachment newItemAttachment) throws ClientException {
        return (ItemAttachment)this.send(HttpMethod.POST, newItemAttachment);
    }

    @Override
    public void put(ItemAttachment newItemAttachment, ICallback<ItemAttachment> callback) {
        this.send(HttpMethod.PUT, callback, newItemAttachment);
    }

    @Override
    public ItemAttachment put(ItemAttachment newItemAttachment) throws ClientException {
        return (ItemAttachment)this.send(HttpMethod.PUT, newItemAttachment);
    }

    @Override
    public IItemAttachmentRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IItemAttachmentRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IItemAttachmentRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

