/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMailFolderDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IMailFolderDeltaCollectionRequest;
import com.microsoft.graph.requests.extensions.MailFolderDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.MailFolderDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MailFolderDeltaCollectionResponse;
import java.util.List;

public class MailFolderDeltaCollectionRequest
extends BaseCollectionRequest<MailFolderDeltaCollectionResponse, IMailFolderDeltaCollectionPage>
implements IMailFolderDeltaCollectionRequest {
    public MailFolderDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MailFolderDeltaCollectionResponse.class, IMailFolderDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMailFolderDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MailFolderDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMailFolderDeltaCollectionPage get() throws ClientException {
        MailFolderDeltaCollectionResponse response = (MailFolderDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IMailFolderDeltaCollectionPage buildFromResponse(MailFolderDeltaCollectionResponse response) {
        MailFolderDeltaCollectionRequestBuilder builder = response.nextLink != null ? new MailFolderDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MailFolderDeltaCollectionPage page = new MailFolderDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IMailFolderDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMailFolderDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMailFolderDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IMailFolderDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }
}

