/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMessageDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.IMessageDeltaCollectionRequest;
import com.microsoft.graph.requests.extensions.MessageDeltaCollectionPage;
import com.microsoft.graph.requests.extensions.MessageDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MessageDeltaCollectionResponse;
import java.util.List;

public class MessageDeltaCollectionRequest
extends BaseCollectionRequest<MessageDeltaCollectionResponse, IMessageDeltaCollectionPage>
implements IMessageDeltaCollectionRequest {
    public MessageDeltaCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MessageDeltaCollectionResponse.class, IMessageDeltaCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IMessageDeltaCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MessageDeltaCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMessageDeltaCollectionPage get() throws ClientException {
        MessageDeltaCollectionResponse response = (MessageDeltaCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    public IMessageDeltaCollectionPage buildFromResponse(MessageDeltaCollectionResponse response) {
        MessageDeltaCollectionRequestBuilder builder = response.nextLink != null ? new MessageDeltaCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MessageDeltaCollectionPage page = new MessageDeltaCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    @Override
    public IMessageDeltaCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMessageDeltaCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMessageDeltaCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IMessageDeltaCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }
}

