/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.OutlookItem;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOutlookItemRequest;
import java.util.List;

public class OutlookItemRequest
extends BaseRequest
implements IOutlookItemRequest {
    public OutlookItemRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, Class<? extends OutlookItem> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public OutlookItemRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OutlookItem.class);
    }

    @Override
    public void get(ICallback<OutlookItem> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public OutlookItem get() throws ClientException {
        return (OutlookItem)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<OutlookItem> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(OutlookItem sourceOutlookItem, ICallback<OutlookItem> callback) {
        this.send(HttpMethod.PATCH, callback, sourceOutlookItem);
    }

    @Override
    public OutlookItem patch(OutlookItem sourceOutlookItem) throws ClientException {
        return (OutlookItem)this.send(HttpMethod.PATCH, sourceOutlookItem);
    }

    @Override
    public void post(OutlookItem newOutlookItem, ICallback<OutlookItem> callback) {
        this.send(HttpMethod.POST, callback, newOutlookItem);
    }

    @Override
    public OutlookItem post(OutlookItem newOutlookItem) throws ClientException {
        return (OutlookItem)this.send(HttpMethod.POST, newOutlookItem);
    }

    @Override
    public void put(OutlookItem newOutlookItem, ICallback<OutlookItem> callback) {
        this.send(HttpMethod.PUT, callback, newOutlookItem);
    }

    @Override
    public OutlookItem put(OutlookItem newOutlookItem) throws ClientException {
        return (OutlookItem)this.send(HttpMethod.PUT, newOutlookItem);
    }

    @Override
    public IOutlookItemRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOutlookItemRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }

    public IOutlookItemRequest filter(String value) {
        this.getQueryOptions().add(new QueryOption("$filter", value));
        return this;
    }
}

