/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ISiteCollectionPage;
import com.microsoft.graph.requests.extensions.ISiteCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.ISiteCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.SiteCollectionResponse;
import com.microsoft.graph.requests.extensions.SiteCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.SiteCollectionWithReferencesRequestBuilder;
import java.util.List;

public class SiteCollectionWithReferencesRequest
extends BaseCollectionRequest<SiteCollectionResponse, ISiteCollectionPage>
implements ISiteCollectionWithReferencesRequest {
    public SiteCollectionWithReferencesRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, SiteCollectionResponse.class, ISiteCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ISiteCollectionWithReferencesPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(SiteCollectionWithReferencesRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ISiteCollectionWithReferencesPage get() throws ClientException {
        SiteCollectionResponse response = (SiteCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public ISiteCollectionWithReferencesRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public ISiteCollectionWithReferencesRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ISiteCollectionWithReferencesRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ISiteCollectionWithReferencesRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    public ISiteCollectionWithReferencesPage buildFromResponse(SiteCollectionResponse response) {
        SiteCollectionWithReferencesRequestBuilder builder = response.nextLink != null ? new SiteCollectionWithReferencesRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        SiteCollectionWithReferencesPage page = new SiteCollectionWithReferencesPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

