/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TargetedManagedAppConfiguration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITargetedManagedAppConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.ITargetedManagedAppConfigurationCollectionRequest;
import com.microsoft.graph.requests.extensions.TargetedManagedAppConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.TargetedManagedAppConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TargetedManagedAppConfigurationCollectionResponse;
import com.microsoft.graph.requests.extensions.TargetedManagedAppConfigurationRequestBuilder;
import java.util.List;

public class TargetedManagedAppConfigurationCollectionRequest
extends BaseCollectionRequest<TargetedManagedAppConfigurationCollectionResponse, ITargetedManagedAppConfigurationCollectionPage>
implements ITargetedManagedAppConfigurationCollectionRequest {
    public TargetedManagedAppConfigurationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TargetedManagedAppConfigurationCollectionResponse.class, ITargetedManagedAppConfigurationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITargetedManagedAppConfigurationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TargetedManagedAppConfigurationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITargetedManagedAppConfigurationCollectionPage get() throws ClientException {
        TargetedManagedAppConfigurationCollectionResponse response = (TargetedManagedAppConfigurationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TargetedManagedAppConfiguration newTargetedManagedAppConfiguration, ICallback<TargetedManagedAppConfiguration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TargetedManagedAppConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTargetedManagedAppConfiguration, callback);
    }

    @Override
    public TargetedManagedAppConfiguration post(TargetedManagedAppConfiguration newTargetedManagedAppConfiguration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TargetedManagedAppConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTargetedManagedAppConfiguration);
    }

    @Override
    public ITargetedManagedAppConfigurationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITargetedManagedAppConfigurationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ITargetedManagedAppConfigurationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITargetedManagedAppConfigurationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITargetedManagedAppConfigurationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITargetedManagedAppConfigurationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITargetedManagedAppConfigurationCollectionPage buildFromResponse(TargetedManagedAppConfigurationCollectionResponse response) {
        TargetedManagedAppConfigurationCollectionRequestBuilder builder = response.nextLink != null ? new TargetedManagedAppConfigurationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TargetedManagedAppConfigurationCollectionPage page = new TargetedManagedAppConfigurationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

