/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.TeamsAsyncOperation;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ITeamsAsyncOperationCollectionPage;
import com.microsoft.graph.requests.extensions.ITeamsAsyncOperationCollectionRequest;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionPage;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationCollectionResponse;
import com.microsoft.graph.requests.extensions.TeamsAsyncOperationRequestBuilder;
import java.util.List;

public class TeamsAsyncOperationCollectionRequest
extends BaseCollectionRequest<TeamsAsyncOperationCollectionResponse, ITeamsAsyncOperationCollectionPage>
implements ITeamsAsyncOperationCollectionRequest {
    public TeamsAsyncOperationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TeamsAsyncOperationCollectionResponse.class, ITeamsAsyncOperationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<ITeamsAsyncOperationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(TeamsAsyncOperationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ITeamsAsyncOperationCollectionPage get() throws ClientException {
        TeamsAsyncOperationCollectionResponse response = (TeamsAsyncOperationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(TeamsAsyncOperation newTeamsAsyncOperation, ICallback<TeamsAsyncOperation> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new TeamsAsyncOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTeamsAsyncOperation, callback);
    }

    @Override
    public TeamsAsyncOperation post(TeamsAsyncOperation newTeamsAsyncOperation) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new TeamsAsyncOperationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newTeamsAsyncOperation);
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ITeamsAsyncOperationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ITeamsAsyncOperationCollectionPage buildFromResponse(TeamsAsyncOperationCollectionResponse response) {
        TeamsAsyncOperationCollectionRequestBuilder builder = response.nextLink != null ? new TeamsAsyncOperationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        TeamsAsyncOperationCollectionPage page = new TeamsAsyncOperationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

