/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ThreatAssessmentRequest;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IThreatAssessmentRequestCollectionPage;
import com.microsoft.graph.requests.extensions.IThreatAssessmentRequestCollectionRequest;
import com.microsoft.graph.requests.extensions.ThreatAssessmentRequestCollectionPage;
import com.microsoft.graph.requests.extensions.ThreatAssessmentRequestCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ThreatAssessmentRequestCollectionResponse;
import com.microsoft.graph.requests.extensions.ThreatAssessmentRequestRequestBuilder;
import java.util.List;

public class ThreatAssessmentRequestCollectionRequest
extends BaseCollectionRequest<ThreatAssessmentRequestCollectionResponse, IThreatAssessmentRequestCollectionPage>
implements IThreatAssessmentRequestCollectionRequest {
    public ThreatAssessmentRequestCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ThreatAssessmentRequestCollectionResponse.class, IThreatAssessmentRequestCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IThreatAssessmentRequestCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ThreatAssessmentRequestCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IThreatAssessmentRequestCollectionPage get() throws ClientException {
        ThreatAssessmentRequestCollectionResponse response = (ThreatAssessmentRequestCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ThreatAssessmentRequest newThreatAssessmentRequest, ICallback<ThreatAssessmentRequest> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ThreatAssessmentRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newThreatAssessmentRequest, callback);
    }

    @Override
    public ThreatAssessmentRequest post(ThreatAssessmentRequest newThreatAssessmentRequest) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ThreatAssessmentRequestRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newThreatAssessmentRequest);
    }

    @Override
    public IThreatAssessmentRequestCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IThreatAssessmentRequestCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IThreatAssessmentRequestCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IThreatAssessmentRequestCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IThreatAssessmentRequestCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IThreatAssessmentRequestCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IThreatAssessmentRequestCollectionPage buildFromResponse(ThreatAssessmentRequestCollectionResponse response) {
        ThreatAssessmentRequestCollectionRequestBuilder builder = response.nextLink != null ? new ThreatAssessmentRequestCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ThreatAssessmentRequestCollectionPage page = new ThreatAssessmentRequestCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

