/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.VppToken;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IVppTokenCollectionPage;
import com.microsoft.graph.requests.extensions.IVppTokenCollectionRequest;
import com.microsoft.graph.requests.extensions.VppTokenCollectionPage;
import com.microsoft.graph.requests.extensions.VppTokenCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.VppTokenCollectionResponse;
import com.microsoft.graph.requests.extensions.VppTokenRequestBuilder;
import java.util.List;

public class VppTokenCollectionRequest
extends BaseCollectionRequest<VppTokenCollectionResponse, IVppTokenCollectionPage>
implements IVppTokenCollectionRequest {
    public VppTokenCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, VppTokenCollectionResponse.class, IVppTokenCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IVppTokenCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(VppTokenCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IVppTokenCollectionPage get() throws ClientException {
        VppTokenCollectionResponse response = (VppTokenCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(VppToken newVppToken, ICallback<VppToken> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new VppTokenRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newVppToken, callback);
    }

    @Override
    public VppToken post(VppToken newVppToken) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new VppTokenRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newVppToken);
    }

    @Override
    public IVppTokenCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IVppTokenCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IVppTokenCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IVppTokenCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IVppTokenCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IVppTokenCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IVppTokenCollectionPage buildFromResponse(VppTokenCollectionResponse response) {
        VppTokenCollectionRequestBuilder builder = response.nextLink != null ? new VppTokenCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        VppTokenCollectionPage page = new VppTokenCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

