/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.WindowsInformationProtectionPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IWindowsInformationProtectionPolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionPolicyRequestBuilder;
import java.util.List;

public class WindowsInformationProtectionPolicyCollectionRequest
extends BaseCollectionRequest<WindowsInformationProtectionPolicyCollectionResponse, IWindowsInformationProtectionPolicyCollectionPage>
implements IWindowsInformationProtectionPolicyCollectionRequest {
    public WindowsInformationProtectionPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsInformationProtectionPolicyCollectionResponse.class, IWindowsInformationProtectionPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IWindowsInformationProtectionPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(WindowsInformationProtectionPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IWindowsInformationProtectionPolicyCollectionPage get() throws ClientException {
        WindowsInformationProtectionPolicyCollectionResponse response = (WindowsInformationProtectionPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(WindowsInformationProtectionPolicy newWindowsInformationProtectionPolicy, ICallback<WindowsInformationProtectionPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new WindowsInformationProtectionPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWindowsInformationProtectionPolicy, callback);
    }

    @Override
    public WindowsInformationProtectionPolicy post(WindowsInformationProtectionPolicy newWindowsInformationProtectionPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new WindowsInformationProtectionPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newWindowsInformationProtectionPolicy);
    }

    @Override
    public IWindowsInformationProtectionPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionPolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IWindowsInformationProtectionPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IWindowsInformationProtectionPolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IWindowsInformationProtectionPolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IWindowsInformationProtectionPolicyCollectionPage buildFromResponse(WindowsInformationProtectionPolicyCollectionResponse response) {
        WindowsInformationProtectionPolicyCollectionRequestBuilder builder = response.nextLink != null ? new WindowsInformationProtectionPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        WindowsInformationProtectionPolicyCollectionPage page = new WindowsInformationProtectionPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

