// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.callrecords.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.callrecords.models.extensions.Endpoint;
import com.microsoft.graph.callrecords.models.extensions.FailureInfo;
import com.microsoft.graph.callrecords.models.generated.Modality;
import com.microsoft.graph.callrecords.models.extensions.Segment;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.callrecords.requests.extensions.SegmentCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Session.
 */
public class Session extends Entity implements IJsonBackedObject {


    /**
     * The Callee.
     * Endpoint that answered the session.
     */
    @SerializedName("callee")
    @Expose
    public Endpoint callee;

    /**
     * The Caller.
     * Endpoint that initiated the session.
     */
    @SerializedName("caller")
    @Expose
    public Endpoint caller;

    /**
     * The End Date Time.
     * UTC time when the last user left the session. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @SerializedName("endDateTime")
    @Expose
    public java.util.Calendar endDateTime;

    /**
     * The Failure Info.
     * Failure information associated with the session if the session failed.
     */
    @SerializedName("failureInfo")
    @Expose
    public FailureInfo failureInfo;

    /**
     * The Modalities.
     * List of modalities present in the session. Possible values are: unknown, audio, video, videoBasedScreenSharing, data, screenSharing, unknownFutureValue.
     */
    @SerializedName("modalities")
    @Expose
    public java.util.List<Modality> modalities;

    /**
     * The Start Date Time.
     * UTC fime when the first user joined the session. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 would look like this: '2014-01-01T00:00:00Z'
     */
    @SerializedName("startDateTime")
    @Expose
    public java.util.Calendar startDateTime;

    /**
     * The Segments.
     * The list of segments involved in the session. Read-only. Nullable.
     */
    @SerializedName("segments")
    @Expose
    public SegmentCollectionPage segments;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("segments")) {
            segments = serializer.deserializeObject(json.get("segments").toString(), SegmentCollectionPage.class);
        }
    }
}
