// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.ManagedEBook;
import com.microsoft.graph.models.extensions.MobileAppCategory;
import com.microsoft.graph.models.extensions.ManagedDeviceMobileAppConfiguration;
import com.microsoft.graph.models.extensions.MobileApp;
import com.microsoft.graph.models.extensions.VppToken;
import com.microsoft.graph.models.extensions.AndroidManagedAppProtection;
import com.microsoft.graph.models.extensions.DefaultManagedAppProtection;
import com.microsoft.graph.models.extensions.IosManagedAppProtection;
import com.microsoft.graph.models.extensions.ManagedAppPolicy;
import com.microsoft.graph.models.extensions.ManagedAppRegistration;
import com.microsoft.graph.models.extensions.ManagedAppStatus;
import com.microsoft.graph.models.extensions.MdmWindowsInformationProtectionPolicy;
import com.microsoft.graph.models.extensions.TargetedManagedAppConfiguration;
import com.microsoft.graph.models.extensions.WindowsInformationProtectionPolicy;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.ManagedEBookCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedDeviceMobileAppConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppCollectionPage;
import com.microsoft.graph.requests.extensions.VppTokenCollectionPage;
import com.microsoft.graph.requests.extensions.AndroidManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.DefaultManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.IosManagedAppProtectionCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppRegistrationCollectionPage;
import com.microsoft.graph.requests.extensions.ManagedAppStatusCollectionPage;
import com.microsoft.graph.requests.extensions.MdmWindowsInformationProtectionPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.TargetedManagedAppConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.WindowsInformationProtectionPolicyCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device App Management.
 */
public class DeviceAppManagement extends Entity implements IJsonBackedObject {


    /**
     * The Is Enabled For Microsoft Store For Business.
     * Whether the account is enabled for syncing applications from the Microsoft Store for Business.
     */
    @SerializedName("isEnabledForMicrosoftStoreForBusiness")
    @Expose
    public Boolean isEnabledForMicrosoftStoreForBusiness;

    /**
     * The Microsoft Store For Business Language.
     * The locale information used to sync applications from the Microsoft Store for Business. Cultures that are specific to a country/region. The names of these cultures follow RFC 4646 (Windows Vista and later). The format is -&amp;lt;country/regioncode2&amp;gt;, where  is a lowercase two-letter code derived from ISO 639-1 and &amp;lt;country/regioncode2&amp;gt; is an uppercase two-letter code derived from ISO 3166. For example, en-US for English (United States) is a specific culture.
     */
    @SerializedName("microsoftStoreForBusinessLanguage")
    @Expose
    public String microsoftStoreForBusinessLanguage;

    /**
     * The Microsoft Store For Business Last Completed Application Sync Time.
     * The last time an application sync from the Microsoft Store for Business was completed.
     */
    @SerializedName("microsoftStoreForBusinessLastCompletedApplicationSyncTime")
    @Expose
    public java.util.Calendar microsoftStoreForBusinessLastCompletedApplicationSyncTime;

    /**
     * The Microsoft Store For Business Last Successful Sync Date Time.
     * The last time the apps from the Microsoft Store for Business were synced successfully for the account.
     */
    @SerializedName("microsoftStoreForBusinessLastSuccessfulSyncDateTime")
    @Expose
    public java.util.Calendar microsoftStoreForBusinessLastSuccessfulSyncDateTime;

    /**
     * The Managed EBooks.
     * The Managed eBook.
     */
    @SerializedName("managedEBooks")
    @Expose
    public ManagedEBookCollectionPage managedEBooks;

    /**
     * The Mobile App Categories.
     * The mobile app categories.
     */
    @SerializedName("mobileAppCategories")
    @Expose
    public MobileAppCategoryCollectionPage mobileAppCategories;

    /**
     * The Mobile App Configurations.
     * The Managed Device Mobile Application Configurations.
     */
    @SerializedName("mobileAppConfigurations")
    @Expose
    public ManagedDeviceMobileAppConfigurationCollectionPage mobileAppConfigurations;

    /**
     * The Mobile Apps.
     * The mobile apps.
     */
    @SerializedName("mobileApps")
    @Expose
    public MobileAppCollectionPage mobileApps;

    /**
     * The Vpp Tokens.
     * List of Vpp tokens for this organization.
     */
    @SerializedName("vppTokens")
    @Expose
    public VppTokenCollectionPage vppTokens;

    /**
     * The Android Managed App Protections.
     * Android managed app policies.
     */
    @SerializedName("androidManagedAppProtections")
    @Expose
    public AndroidManagedAppProtectionCollectionPage androidManagedAppProtections;

    /**
     * The Default Managed App Protections.
     * Default managed app policies.
     */
    @SerializedName("defaultManagedAppProtections")
    @Expose
    public DefaultManagedAppProtectionCollectionPage defaultManagedAppProtections;

    /**
     * The Ios Managed App Protections.
     * iOS managed app policies.
     */
    @SerializedName("iosManagedAppProtections")
    @Expose
    public IosManagedAppProtectionCollectionPage iosManagedAppProtections;

    /**
     * The Managed App Policies.
     * Managed app policies.
     */
    @SerializedName("managedAppPolicies")
    @Expose
    public ManagedAppPolicyCollectionPage managedAppPolicies;

    /**
     * The Managed App Registrations.
     * The managed app registrations.
     */
    @SerializedName("managedAppRegistrations")
    @Expose
    public ManagedAppRegistrationCollectionPage managedAppRegistrations;

    /**
     * The Managed App Statuses.
     * The managed app statuses.
     */
    @SerializedName("managedAppStatuses")
    @Expose
    public ManagedAppStatusCollectionPage managedAppStatuses;

    /**
     * The Mdm Windows Information Protection Policies.
     * Windows information protection for apps running on devices which are MDM enrolled.
     */
    @SerializedName("mdmWindowsInformationProtectionPolicies")
    @Expose
    public MdmWindowsInformationProtectionPolicyCollectionPage mdmWindowsInformationProtectionPolicies;

    /**
     * The Targeted Managed App Configurations.
     * Targeted managed app configurations.
     */
    @SerializedName("targetedManagedAppConfigurations")
    @Expose
    public TargetedManagedAppConfigurationCollectionPage targetedManagedAppConfigurations;

    /**
     * The Windows Information Protection Policies.
     * Windows information protection for apps running on devices which are not MDM enrolled.
     */
    @SerializedName("windowsInformationProtectionPolicies")
    @Expose
    public WindowsInformationProtectionPolicyCollectionPage windowsInformationProtectionPolicies;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("managedEBooks")) {
            managedEBooks = serializer.deserializeObject(json.get("managedEBooks").toString(), ManagedEBookCollectionPage.class);
        }

        if (json.has("mobileAppCategories")) {
            mobileAppCategories = serializer.deserializeObject(json.get("mobileAppCategories").toString(), MobileAppCategoryCollectionPage.class);
        }

        if (json.has("mobileAppConfigurations")) {
            mobileAppConfigurations = serializer.deserializeObject(json.get("mobileAppConfigurations").toString(), ManagedDeviceMobileAppConfigurationCollectionPage.class);
        }

        if (json.has("mobileApps")) {
            mobileApps = serializer.deserializeObject(json.get("mobileApps").toString(), MobileAppCollectionPage.class);
        }

        if (json.has("vppTokens")) {
            vppTokens = serializer.deserializeObject(json.get("vppTokens").toString(), VppTokenCollectionPage.class);
        }

        if (json.has("androidManagedAppProtections")) {
            androidManagedAppProtections = serializer.deserializeObject(json.get("androidManagedAppProtections").toString(), AndroidManagedAppProtectionCollectionPage.class);
        }

        if (json.has("defaultManagedAppProtections")) {
            defaultManagedAppProtections = serializer.deserializeObject(json.get("defaultManagedAppProtections").toString(), DefaultManagedAppProtectionCollectionPage.class);
        }

        if (json.has("iosManagedAppProtections")) {
            iosManagedAppProtections = serializer.deserializeObject(json.get("iosManagedAppProtections").toString(), IosManagedAppProtectionCollectionPage.class);
        }

        if (json.has("managedAppPolicies")) {
            managedAppPolicies = serializer.deserializeObject(json.get("managedAppPolicies").toString(), ManagedAppPolicyCollectionPage.class);
        }

        if (json.has("managedAppRegistrations")) {
            managedAppRegistrations = serializer.deserializeObject(json.get("managedAppRegistrations").toString(), ManagedAppRegistrationCollectionPage.class);
        }

        if (json.has("managedAppStatuses")) {
            managedAppStatuses = serializer.deserializeObject(json.get("managedAppStatuses").toString(), ManagedAppStatusCollectionPage.class);
        }

        if (json.has("mdmWindowsInformationProtectionPolicies")) {
            mdmWindowsInformationProtectionPolicies = serializer.deserializeObject(json.get("mdmWindowsInformationProtectionPolicies").toString(), MdmWindowsInformationProtectionPolicyCollectionPage.class);
        }

        if (json.has("targetedManagedAppConfigurations")) {
            targetedManagedAppConfigurations = serializer.deserializeObject(json.get("targetedManagedAppConfigurations").toString(), TargetedManagedAppConfigurationCollectionPage.class);
        }

        if (json.has("windowsInformationProtectionPolicies")) {
            windowsInformationProtectionPolicies = serializer.deserializeObject(json.get("windowsInformationProtectionPolicies").toString(), WindowsInformationProtectionPolicyCollectionPage.class);
        }
    }
}
