// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.DirectoryObject;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Partner Reference.
 */
public class DirectoryObjectPartnerReference extends DirectoryObject implements IJsonBackedObject {


    /**
     * The Description.
     * Description of the object returned. Read-only.
     */
    @SerializedName("description")
    @Expose
    public String description;

    /**
     * The Display Name.
     * Name of directory object being returned, like group or application. Read-only.
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The External Partner Tenant Id.
     * The tenant identifier for the partner tenant. Read-only.
     */
    @SerializedName("externalPartnerTenantId")
    @Expose
    public java.util.UUID externalPartnerTenantId;

    /**
     * The Object Type.
     * The type of the referenced object in the partner tenant. Read-only.
     */
    @SerializedName("objectType")
    @Expose
    public String objectType;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
