// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Malware State.
 */
public class MalwareState implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Category.
     * Provider-generated malware category (for example, trojan, ransomware, etc.).
     */
    @SerializedName("category")
    @Expose
    public String category;

    /**
     * The Family.
     * Provider-generated malware family (for example, 'wannacry', 'notpetya', etc.).
     */
    @SerializedName("family")
    @Expose
    public String family;

    /**
     * The Name.
     * Provider-generated malware variant name (for example, Trojan:Win32/Powessere.H).
     */
    @SerializedName("name")
    @Expose
    public String name;

    /**
     * The Severity.
     * Provider-determined severity of this malware.
     */
    @SerializedName("severity")
    @Expose
    public String severity;

    /**
     * The Was Running.
     * Indicates whether the detected file (malware/vulnerability) was running at the time of detection or was detected at rest on the disk.
     */
    @SerializedName("wasRunning")
    @Expose
    public Boolean wasRunning;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
