// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.MimeContent;
import com.microsoft.graph.models.generated.MobileAppPublishingState;
import com.microsoft.graph.models.extensions.MobileAppAssignment;
import com.microsoft.graph.models.extensions.MobileAppCategory;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.MobileAppAssignmentCollectionPage;
import com.microsoft.graph.requests.extensions.MobileAppCategoryCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile App.
 */
public class MobileApp extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * The date and time the app was created.
     */
    @SerializedName("createdDateTime")
    @Expose
    public java.util.Calendar createdDateTime;

    /**
     * The Description.
     * The description of the app.
     */
    @SerializedName("description")
    @Expose
    public String description;

    /**
     * The Developer.
     * The developer of the app.
     */
    @SerializedName("developer")
    @Expose
    public String developer;

    /**
     * The Display Name.
     * The admin provided or imported title of the app.
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Information Url.
     * The more information Url.
     */
    @SerializedName("informationUrl")
    @Expose
    public String informationUrl;

    /**
     * The Is Featured.
     * The value indicating whether the app is marked as featured by the admin.
     */
    @SerializedName("isFeatured")
    @Expose
    public Boolean isFeatured;

    /**
     * The Large Icon.
     * The large icon, to be displayed in the app details and used for upload of the icon.
     */
    @SerializedName("largeIcon")
    @Expose
    public MimeContent largeIcon;

    /**
     * The Last Modified Date Time.
     * The date and time the app was last modified.
     */
    @SerializedName("lastModifiedDateTime")
    @Expose
    public java.util.Calendar lastModifiedDateTime;

    /**
     * The Notes.
     * Notes for the app.
     */
    @SerializedName("notes")
    @Expose
    public String notes;

    /**
     * The Owner.
     * The owner of the app.
     */
    @SerializedName("owner")
    @Expose
    public String owner;

    /**
     * The Privacy Information Url.
     * The privacy statement Url.
     */
    @SerializedName("privacyInformationUrl")
    @Expose
    public String privacyInformationUrl;

    /**
     * The Publisher.
     * The publisher of the app.
     */
    @SerializedName("publisher")
    @Expose
    public String publisher;

    /**
     * The Publishing State.
     * The publishing state for the app. The app cannot be assigned unless the app is published. Possible values are: notPublished, processing, published.
     */
    @SerializedName("publishingState")
    @Expose
    public MobileAppPublishingState publishingState;

    /**
     * The Assignments.
     * The list of group assignments for this mobile app.
     */
    @SerializedName("assignments")
    @Expose
    public MobileAppAssignmentCollectionPage assignments;

    /**
     * The Categories.
     * The list of categories for this app.
     */
    public MobileAppCategoryCollectionPage categories;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("assignments")) {
            assignments = serializer.deserializeObject(json.get("assignments").toString(), MobileAppAssignmentCollectionPage.class);
        }

        if (json.has("categories")) {
            categories = serializer.deserializeObject(json.get("categories").toString(), MobileAppCategoryCollectionPage.class);
        }
    }
}
