// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.PermissionType;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Permission Grant Condition Set.
 */
public class PermissionGrantConditionSet extends Entity implements IJsonBackedObject {


    /**
     * The Client Application Ids.
     * 
     */
    @SerializedName("clientApplicationIds")
    @Expose
    public java.util.List<String> clientApplicationIds;

    /**
     * The Client Application Publisher Ids.
     * 
     */
    @SerializedName("clientApplicationPublisherIds")
    @Expose
    public java.util.List<String> clientApplicationPublisherIds;

    /**
     * The Client Applications From Verified Publisher Only.
     * 
     */
    @SerializedName("clientApplicationsFromVerifiedPublisherOnly")
    @Expose
    public Boolean clientApplicationsFromVerifiedPublisherOnly;

    /**
     * The Client Application Tenant Ids.
     * 
     */
    @SerializedName("clientApplicationTenantIds")
    @Expose
    public java.util.List<String> clientApplicationTenantIds;

    /**
     * The Permission Classification.
     * 
     */
    @SerializedName("permissionClassification")
    @Expose
    public String permissionClassification;

    /**
     * The Permissions.
     * 
     */
    @SerializedName("permissions")
    @Expose
    public java.util.List<String> permissions;

    /**
     * The Permission Type.
     * 
     */
    @SerializedName("permissionType")
    @Expose
    public PermissionType permissionType;

    /**
     * The Resource Application.
     * 
     */
    @SerializedName("resourceApplication")
    @Expose
    public String resourceApplication;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
