// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Security Vendor Information.
 */
public class SecurityVendorInformation implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Provider.
     * Specific provider (product/service - not vendor company); for example, WindowsDefenderATP.
     */
    @SerializedName("provider")
    @Expose
    public String provider;

    /**
     * The Provider Version.
     * Version of the provider or subprovider, if it exists, that generated the alert. Required
     */
    @SerializedName("providerVersion")
    @Expose
    public String providerVersion;

    /**
     * The Sub Provider.
     * Specific subprovider (under aggregating provider); for example, WindowsDefenderATP.SmartScreen.
     */
    @SerializedName("subProvider")
    @Expose
    public String subProvider;

    /**
     * The Vendor.
     * Name of the alert vendor (for example, Microsoft, Dell, FireEye). Required
     */
    @SerializedName("vendor")
    @Expose
    public String vendor;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
