// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.SharingDetail;
import com.microsoft.graph.models.extensions.ResourceReference;
import com.microsoft.graph.models.extensions.ResourceVisualization;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared Insight.
 */
public class SharedInsight extends Entity implements IJsonBackedObject {


    /**
     * The Last Shared.
     * Details about the shared item. Read only.
     */
    @SerializedName("lastShared")
    @Expose
    public SharingDetail lastShared;

    /**
     * The Resource Reference.
     * Reference properties of the shared document, such as the url and type of the document. Read-only
     */
    @SerializedName("resourceReference")
    @Expose
    public ResourceReference resourceReference;

    /**
     * The Resource Visualization.
     * Properties that you can use to visualize the document in your experience. Read-only
     */
    @SerializedName("resourceVisualization")
    @Expose
    public ResourceVisualization resourceVisualization;

    /**
     * The Sharing History.
     * 
     */
    @SerializedName("sharingHistory")
    @Expose
    public java.util.List<SharingDetail> sharingHistory;

    /**
     * The Last Shared Method.
     * 
     */
    @SerializedName("lastSharedMethod")
    @Expose
    public Entity lastSharedMethod;

    /**
     * The Resource.
     * Used for navigating to the item that was shared. For file attachments, the type is fileAttachment. For linked attachments, the type is driveItem.
     */
    @SerializedName("resource")
    @Expose
    public Entity resource;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
