// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.DeviceInstallState;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.DeviceInstallStateCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Install State Summary.
 */
public class UserInstallStateSummary extends Entity implements IJsonBackedObject {


    /**
     * The Failed Device Count.
     * Failed Device Count.
     */
    @SerializedName("failedDeviceCount")
    @Expose
    public Integer failedDeviceCount;

    /**
     * The Installed Device Count.
     * Installed Device Count.
     */
    @SerializedName("installedDeviceCount")
    @Expose
    public Integer installedDeviceCount;

    /**
     * The Not Installed Device Count.
     * Not installed device count.
     */
    @SerializedName("notInstalledDeviceCount")
    @Expose
    public Integer notInstalledDeviceCount;

    /**
     * The User Name.
     * User name.
     */
    @SerializedName("userName")
    @Expose
    public String userName;

    /**
     * The Device States.
     * The install state of the eBook.
     */
    @SerializedName("deviceStates")
    @Expose
    public DeviceInstallStateCollectionPage deviceStates;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("deviceStates")) {
            deviceStates = serializer.deserializeObject(json.get("deviceStates").toString(), DeviceInstallStateCollectionPage.class);
        }
    }
}
