// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.MobileAppInstallTimeSettings;
import com.microsoft.graph.models.generated.Win32LobAppNotification;
import com.microsoft.graph.models.extensions.Win32LobAppRestartSettings;
import com.microsoft.graph.models.extensions.MobileAppAssignmentSettings;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Win32Lob App Assignment Settings.
 */
public class Win32LobAppAssignmentSettings extends MobileAppAssignmentSettings implements IJsonBackedObject {


    /**
     * The Install Time Settings.
     * The install time settings to apply for this app assignment.
     */
    @SerializedName("installTimeSettings")
    @Expose
    public MobileAppInstallTimeSettings installTimeSettings;

    /**
     * The Notifications.
     * The notification status for this app assignment. Possible values are: showAll, showReboot, hideAll.
     */
    @SerializedName("notifications")
    @Expose
    public Win32LobAppNotification notifications;

    /**
     * The Restart Settings.
     * The reboot settings to apply for this app assignment.
     */
    @SerializedName("restartSettings")
    @Expose
    public Win32LobAppRestartSettings restartSettings;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
