// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.StateManagementSetting;
import com.microsoft.graph.models.generated.DefenderCloudBlockLevelType;
import com.microsoft.graph.models.extensions.DefenderDetectedMalwareActions;
import com.microsoft.graph.models.generated.DefenderMonitorFileActivity;
import com.microsoft.graph.models.generated.DefenderPromptForSampleSubmission;
import com.microsoft.graph.models.generated.DefenderScanType;
import com.microsoft.graph.models.generated.WeeklySchedule;
import com.microsoft.graph.models.generated.DiagnosticDataSubmissionMode;
import com.microsoft.graph.models.generated.EdgeCookiePolicy;
import com.microsoft.graph.models.extensions.EdgeSearchEngineBase;
import com.microsoft.graph.models.extensions.Windows10NetworkProxyServer;
import com.microsoft.graph.models.generated.RequiredPasswordType;
import com.microsoft.graph.models.generated.SafeSearchFilterType;
import com.microsoft.graph.models.generated.WindowsStartMenuAppListVisibilityType;
import com.microsoft.graph.models.generated.WindowsStartMenuModeType;
import com.microsoft.graph.models.generated.VisibilitySetting;
import com.microsoft.graph.models.generated.WindowsSpotlightEnablementSettings;
import com.microsoft.graph.models.extensions.DeviceConfiguration;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows10General Configuration.
 */
public class Windows10GeneralConfiguration extends DeviceConfiguration implements IJsonBackedObject {


    /**
     * The Accounts Block Adding Non Microsoft Account Email.
     * Indicates whether or not to Block the user from adding email accounts to the device that are not associated with a Microsoft account.
     */
    @SerializedName("accountsBlockAddingNonMicrosoftAccountEmail")
    @Expose
    public Boolean accountsBlockAddingNonMicrosoftAccountEmail;

    /**
     * The Anti Theft Mode Blocked.
     * Indicates whether or not to block the user from selecting an AntiTheft mode preference (Windows 10 Mobile only).
     */
    @SerializedName("antiTheftModeBlocked")
    @Expose
    public Boolean antiTheftModeBlocked;

    /**
     * The Apps Allow Trusted Apps Sideloading.
     * Indicates whether apps from AppX packages signed with a trusted certificate can be side loaded. Possible values are: notConfigured, blocked, allowed.
     */
    @SerializedName("appsAllowTrustedAppsSideloading")
    @Expose
    public StateManagementSetting appsAllowTrustedAppsSideloading;

    /**
     * The Apps Block Windows Store Originated Apps.
     * Indicates whether or not to disable the launch of all apps from Windows Store that came pre-installed or were downloaded.
     */
    @SerializedName("appsBlockWindowsStoreOriginatedApps")
    @Expose
    public Boolean appsBlockWindowsStoreOriginatedApps;

    /**
     * The Bluetooth Allowed Services.
     * Specify a list of allowed Bluetooth services and profiles in hex formatted strings.
     */
    @SerializedName("bluetoothAllowedServices")
    @Expose
    public java.util.List<String> bluetoothAllowedServices;

    /**
     * The Bluetooth Block Advertising.
     * Whether or not to Block the user from using bluetooth advertising.
     */
    @SerializedName("bluetoothBlockAdvertising")
    @Expose
    public Boolean bluetoothBlockAdvertising;

    /**
     * The Bluetooth Block Discoverable Mode.
     * Whether or not to Block the user from using bluetooth discoverable mode.
     */
    @SerializedName("bluetoothBlockDiscoverableMode")
    @Expose
    public Boolean bluetoothBlockDiscoverableMode;

    /**
     * The Bluetooth Blocked.
     * Whether or not to Block the user from using bluetooth.
     */
    @SerializedName("bluetoothBlocked")
    @Expose
    public Boolean bluetoothBlocked;

    /**
     * The Bluetooth Block Pre Pairing.
     * Whether or not to block specific bundled Bluetooth peripherals to automatically pair with the host device.
     */
    @SerializedName("bluetoothBlockPrePairing")
    @Expose
    public Boolean bluetoothBlockPrePairing;

    /**
     * The Camera Blocked.
     * Whether or not to Block the user from accessing the camera of the device.
     */
    @SerializedName("cameraBlocked")
    @Expose
    public Boolean cameraBlocked;

    /**
     * The Cellular Block Data When Roaming.
     * Whether or not to Block the user from using data over cellular while roaming.
     */
    @SerializedName("cellularBlockDataWhenRoaming")
    @Expose
    public Boolean cellularBlockDataWhenRoaming;

    /**
     * The Cellular Block Vpn.
     * Whether or not to Block the user from using VPN over cellular.
     */
    @SerializedName("cellularBlockVpn")
    @Expose
    public Boolean cellularBlockVpn;

    /**
     * The Cellular Block Vpn When Roaming.
     * Whether or not to Block the user from using VPN when roaming over cellular.
     */
    @SerializedName("cellularBlockVpnWhenRoaming")
    @Expose
    public Boolean cellularBlockVpnWhenRoaming;

    /**
     * The Certificates Block Manual Root Certificate Installation.
     * Whether or not to Block the user from doing manual root certificate installation.
     */
    @SerializedName("certificatesBlockManualRootCertificateInstallation")
    @Expose
    public Boolean certificatesBlockManualRootCertificateInstallation;

    /**
     * The Connected Devices Service Blocked.
     * Whether or not to block Connected Devices Service which enables discovery and connection to other devices, remote messaging, remote app sessions and other cross-device experiences.
     */
    @SerializedName("connectedDevicesServiceBlocked")
    @Expose
    public Boolean connectedDevicesServiceBlocked;

    /**
     * The Copy Paste Blocked.
     * Whether or not to Block the user from using copy paste.
     */
    @SerializedName("copyPasteBlocked")
    @Expose
    public Boolean copyPasteBlocked;

    /**
     * The Cortana Blocked.
     * Whether or not to Block the user from using Cortana.
     */
    @SerializedName("cortanaBlocked")
    @Expose
    public Boolean cortanaBlocked;

    /**
     * The Defender Block End User Access.
     * Whether or not to block end user access to Defender.
     */
    @SerializedName("defenderBlockEndUserAccess")
    @Expose
    public Boolean defenderBlockEndUserAccess;

    /**
     * The Defender Cloud Block Level.
     * Specifies the level of cloud-delivered protection. Possible values are: notConfigured, high, highPlus, zeroTolerance.
     */
    @SerializedName("defenderCloudBlockLevel")
    @Expose
    public DefenderCloudBlockLevelType defenderCloudBlockLevel;

    /**
     * The Defender Days Before Deleting Quarantined Malware.
     * Number of days before deleting quarantined malware. Valid values 0 to 90
     */
    @SerializedName("defenderDaysBeforeDeletingQuarantinedMalware")
    @Expose
    public Integer defenderDaysBeforeDeletingQuarantinedMalware;

    /**
     * The Defender Detected Malware Actions.
     * Gets or sets Defender’s actions to take on detected Malware per threat level.
     */
    @SerializedName("defenderDetectedMalwareActions")
    @Expose
    public DefenderDetectedMalwareActions defenderDetectedMalwareActions;

    /**
     * The Defender File Extensions To Exclude.
     * File extensions to exclude from scans and real time protection.
     */
    @SerializedName("defenderFileExtensionsToExclude")
    @Expose
    public java.util.List<String> defenderFileExtensionsToExclude;

    /**
     * The Defender Files And Folders To Exclude.
     * Files and folder to exclude from scans and real time protection.
     */
    @SerializedName("defenderFilesAndFoldersToExclude")
    @Expose
    public java.util.List<String> defenderFilesAndFoldersToExclude;

    /**
     * The Defender Monitor File Activity.
     * Value for monitoring file activity. Possible values are: userDefined, disable, monitorAllFiles, monitorIncomingFilesOnly, monitorOutgoingFilesOnly.
     */
    @SerializedName("defenderMonitorFileActivity")
    @Expose
    public DefenderMonitorFileActivity defenderMonitorFileActivity;

    /**
     * The Defender Processes To Exclude.
     * Processes to exclude from scans and real time protection.
     */
    @SerializedName("defenderProcessesToExclude")
    @Expose
    public java.util.List<String> defenderProcessesToExclude;

    /**
     * The Defender Prompt For Sample Submission.
     * The configuration for how to prompt user for sample submission. Possible values are: userDefined, alwaysPrompt, promptBeforeSendingPersonalData, neverSendData, sendAllDataWithoutPrompting.
     */
    @SerializedName("defenderPromptForSampleSubmission")
    @Expose
    public DefenderPromptForSampleSubmission defenderPromptForSampleSubmission;

    /**
     * The Defender Require Behavior Monitoring.
     * Indicates whether or not to require behavior monitoring.
     */
    @SerializedName("defenderRequireBehaviorMonitoring")
    @Expose
    public Boolean defenderRequireBehaviorMonitoring;

    /**
     * The Defender Require Cloud Protection.
     * Indicates whether or not to require cloud protection.
     */
    @SerializedName("defenderRequireCloudProtection")
    @Expose
    public Boolean defenderRequireCloudProtection;

    /**
     * The Defender Require Network Inspection System.
     * Indicates whether or not to require network inspection system.
     */
    @SerializedName("defenderRequireNetworkInspectionSystem")
    @Expose
    public Boolean defenderRequireNetworkInspectionSystem;

    /**
     * The Defender Require Real Time Monitoring.
     * Indicates whether or not to require real time monitoring.
     */
    @SerializedName("defenderRequireRealTimeMonitoring")
    @Expose
    public Boolean defenderRequireRealTimeMonitoring;

    /**
     * The Defender Scan Archive Files.
     * Indicates whether or not to scan archive files.
     */
    @SerializedName("defenderScanArchiveFiles")
    @Expose
    public Boolean defenderScanArchiveFiles;

    /**
     * The Defender Scan Downloads.
     * Indicates whether or not to scan downloads.
     */
    @SerializedName("defenderScanDownloads")
    @Expose
    public Boolean defenderScanDownloads;

    /**
     * The Defender Scan Incoming Mail.
     * Indicates whether or not to scan incoming mail messages.
     */
    @SerializedName("defenderScanIncomingMail")
    @Expose
    public Boolean defenderScanIncomingMail;

    /**
     * The Defender Scan Mapped Network Drives During Full Scan.
     * Indicates whether or not to scan mapped network drives during full scan.
     */
    @SerializedName("defenderScanMappedNetworkDrivesDuringFullScan")
    @Expose
    public Boolean defenderScanMappedNetworkDrivesDuringFullScan;

    /**
     * The Defender Scan Max Cpu.
     * Max CPU usage percentage during scan. Valid values 0 to 100
     */
    @SerializedName("defenderScanMaxCpu")
    @Expose
    public Integer defenderScanMaxCpu;

    /**
     * The Defender Scan Network Files.
     * Indicates whether or not to scan files opened from a network folder.
     */
    @SerializedName("defenderScanNetworkFiles")
    @Expose
    public Boolean defenderScanNetworkFiles;

    /**
     * The Defender Scan Removable Drives During Full Scan.
     * Indicates whether or not to scan removable drives during full scan.
     */
    @SerializedName("defenderScanRemovableDrivesDuringFullScan")
    @Expose
    public Boolean defenderScanRemovableDrivesDuringFullScan;

    /**
     * The Defender Scan Scripts Loaded In Internet Explorer.
     * Indicates whether or not to scan scripts loaded in Internet Explorer browser.
     */
    @SerializedName("defenderScanScriptsLoadedInInternetExplorer")
    @Expose
    public Boolean defenderScanScriptsLoadedInInternetExplorer;

    /**
     * The Defender Scan Type.
     * The defender system scan type. Possible values are: userDefined, disabled, quick, full.
     */
    @SerializedName("defenderScanType")
    @Expose
    public DefenderScanType defenderScanType;

    /**
     * The Defender Scheduled Quick Scan Time.
     * The time to perform a daily quick scan.
     */
    @SerializedName("defenderScheduledQuickScanTime")
    @Expose
    public com.microsoft.graph.models.extensions.TimeOfDay defenderScheduledQuickScanTime;

    /**
     * The Defender Scheduled Scan Time.
     * The defender time for the system scan.
     */
    @SerializedName("defenderScheduledScanTime")
    @Expose
    public com.microsoft.graph.models.extensions.TimeOfDay defenderScheduledScanTime;

    /**
     * The Defender Signature Update Interval In Hours.
     * The signature update interval in hours. Specify 0 not to check. Valid values 0 to 24
     */
    @SerializedName("defenderSignatureUpdateIntervalInHours")
    @Expose
    public Integer defenderSignatureUpdateIntervalInHours;

    /**
     * The Defender System Scan Schedule.
     * Defender day of the week for the system scan. Possible values are: userDefined, everyday, sunday, monday, tuesday, wednesday, thursday, friday, saturday.
     */
    @SerializedName("defenderSystemScanSchedule")
    @Expose
    public WeeklySchedule defenderSystemScanSchedule;

    /**
     * The Developer Unlock Setting.
     * Indicates whether or not to allow developer unlock. Possible values are: notConfigured, blocked, allowed.
     */
    @SerializedName("developerUnlockSetting")
    @Expose
    public StateManagementSetting developerUnlockSetting;

    /**
     * The Device Management Block Factory Reset On Mobile.
     * Indicates whether or not to Block the user from resetting their phone.
     */
    @SerializedName("deviceManagementBlockFactoryResetOnMobile")
    @Expose
    public Boolean deviceManagementBlockFactoryResetOnMobile;

    /**
     * The Device Management Block Manual Unenroll.
     * Indicates whether or not to Block the user from doing manual un-enrollment from device management.
     */
    @SerializedName("deviceManagementBlockManualUnenroll")
    @Expose
    public Boolean deviceManagementBlockManualUnenroll;

    /**
     * The Diagnostics Data Submission Mode.
     * Gets or sets a value allowing the device to send diagnostic and usage telemetry data, such as Watson. Possible values are: userDefined, none, basic, enhanced, full.
     */
    @SerializedName("diagnosticsDataSubmissionMode")
    @Expose
    public DiagnosticDataSubmissionMode diagnosticsDataSubmissionMode;

    /**
     * The Edge Allow Start Pages Modification.
     * Allow users to change Start pages on Edge. Use the EdgeHomepageUrls to specify the Start pages that the user would see by default when they open Edge.
     */
    @SerializedName("edgeAllowStartPagesModification")
    @Expose
    public Boolean edgeAllowStartPagesModification;

    /**
     * The Edge Block Access To About Flags.
     * Indicates whether or not to prevent access to about flags on Edge browser.
     */
    @SerializedName("edgeBlockAccessToAboutFlags")
    @Expose
    public Boolean edgeBlockAccessToAboutFlags;

    /**
     * The Edge Block Address Bar Dropdown.
     * Block the address bar dropdown functionality in Microsoft Edge. Disable this settings to minimize network connections from Microsoft Edge to Microsoft services.
     */
    @SerializedName("edgeBlockAddressBarDropdown")
    @Expose
    public Boolean edgeBlockAddressBarDropdown;

    /**
     * The Edge Block Autofill.
     * Indicates whether or not to block auto fill.
     */
    @SerializedName("edgeBlockAutofill")
    @Expose
    public Boolean edgeBlockAutofill;

    /**
     * The Edge Block Compatibility List.
     * Block Microsoft compatibility list in Microsoft Edge. This list from Microsoft helps Edge properly display sites with known compatibility issues.
     */
    @SerializedName("edgeBlockCompatibilityList")
    @Expose
    public Boolean edgeBlockCompatibilityList;

    /**
     * The Edge Block Developer Tools.
     * Indicates whether or not to block developer tools in the Edge browser.
     */
    @SerializedName("edgeBlockDeveloperTools")
    @Expose
    public Boolean edgeBlockDeveloperTools;

    /**
     * The Edge Blocked.
     * Indicates whether or not to Block the user from using the Edge browser.
     */
    @SerializedName("edgeBlocked")
    @Expose
    public Boolean edgeBlocked;

    /**
     * The Edge Block Extensions.
     * Indicates whether or not to block extensions in the Edge browser.
     */
    @SerializedName("edgeBlockExtensions")
    @Expose
    public Boolean edgeBlockExtensions;

    /**
     * The Edge Block In Private Browsing.
     * Indicates whether or not to block InPrivate browsing on corporate networks, in the Edge browser.
     */
    @SerializedName("edgeBlockInPrivateBrowsing")
    @Expose
    public Boolean edgeBlockInPrivateBrowsing;

    /**
     * The Edge Block Java Script.
     * Indicates whether or not to Block the user from using JavaScript.
     */
    @SerializedName("edgeBlockJavaScript")
    @Expose
    public Boolean edgeBlockJavaScript;

    /**
     * The Edge Block Live Tile Data Collection.
     * Block the collection of information by Microsoft for live tile creation when users pin a site to Start from Microsoft Edge.
     */
    @SerializedName("edgeBlockLiveTileDataCollection")
    @Expose
    public Boolean edgeBlockLiveTileDataCollection;

    /**
     * The Edge Block Password Manager.
     * Indicates whether or not to Block password manager.
     */
    @SerializedName("edgeBlockPasswordManager")
    @Expose
    public Boolean edgeBlockPasswordManager;

    /**
     * The Edge Block Popups.
     * Indicates whether or not to block popups.
     */
    @SerializedName("edgeBlockPopups")
    @Expose
    public Boolean edgeBlockPopups;

    /**
     * The Edge Block Search Suggestions.
     * Indicates whether or not to block the user from using the search suggestions in the address bar.
     */
    @SerializedName("edgeBlockSearchSuggestions")
    @Expose
    public Boolean edgeBlockSearchSuggestions;

    /**
     * The Edge Block Sending Do Not Track Header.
     * Indicates whether or not to Block the user from sending the do not track header.
     */
    @SerializedName("edgeBlockSendingDoNotTrackHeader")
    @Expose
    public Boolean edgeBlockSendingDoNotTrackHeader;

    /**
     * The Edge Block Sending Intranet Traffic To Internet Explorer.
     * Indicates whether or not to switch the intranet traffic from Edge to Internet Explorer. Note: the name of this property is misleading; the property is obsolete, use EdgeSendIntranetTrafficToInternetExplorer instead.
     */
    @SerializedName("edgeBlockSendingIntranetTrafficToInternetExplorer")
    @Expose
    public Boolean edgeBlockSendingIntranetTrafficToInternetExplorer;

    /**
     * The Edge Clear Browsing Data On Exit.
     * Clear browsing data on exiting Microsoft Edge.
     */
    @SerializedName("edgeClearBrowsingDataOnExit")
    @Expose
    public Boolean edgeClearBrowsingDataOnExit;

    /**
     * The Edge Cookie Policy.
     * Indicates which cookies to block in the Edge browser. Possible values are: userDefined, allow, blockThirdParty, blockAll.
     */
    @SerializedName("edgeCookiePolicy")
    @Expose
    public EdgeCookiePolicy edgeCookiePolicy;

    /**
     * The Edge Disable First Run Page.
     * Block the Microsoft web page that opens on the first use of Microsoft Edge. This policy allows enterprises, like those enrolled in zero emissions configurations, to block this page.
     */
    @SerializedName("edgeDisableFirstRunPage")
    @Expose
    public Boolean edgeDisableFirstRunPage;

    /**
     * The Edge Enterprise Mode Site List Location.
     * Indicates the enterprise mode site list location. Could be a local file, local network or http location.
     */
    @SerializedName("edgeEnterpriseModeSiteListLocation")
    @Expose
    public String edgeEnterpriseModeSiteListLocation;

    /**
     * The Edge First Run Url.
     * The first run URL for when Edge browser is opened for the first time.
     */
    @SerializedName("edgeFirstRunUrl")
    @Expose
    public String edgeFirstRunUrl;

    /**
     * The Edge Homepage Urls.
     * The list of URLs for homepages shodwn on MDM-enrolled devices on Edge browser.
     */
    @SerializedName("edgeHomepageUrls")
    @Expose
    public java.util.List<String> edgeHomepageUrls;

    /**
     * The Edge Require Smart Screen.
     * Indicates whether or not to Require the user to use the smart screen filter.
     */
    @SerializedName("edgeRequireSmartScreen")
    @Expose
    public Boolean edgeRequireSmartScreen;

    /**
     * The Edge Search Engine.
     * Allows IT admins to set a default search engine for MDM-Controlled devices. Users can override this and change their default search engine provided the AllowSearchEngineCustomization policy is not set.
     */
    @SerializedName("edgeSearchEngine")
    @Expose
    public EdgeSearchEngineBase edgeSearchEngine;

    /**
     * The Edge Send Intranet Traffic To Internet Explorer.
     * Indicates whether or not to switch the intranet traffic from Edge to Internet Explorer.
     */
    @SerializedName("edgeSendIntranetTrafficToInternetExplorer")
    @Expose
    public Boolean edgeSendIntranetTrafficToInternetExplorer;

    /**
     * The Edge Sync Favorites With Internet Explorer.
     * Enable favorites sync between Internet Explorer and Microsoft Edge. Additions, deletions, modifications and order changes to favorites are shared between browsers.
     */
    @SerializedName("edgeSyncFavoritesWithInternetExplorer")
    @Expose
    public Boolean edgeSyncFavoritesWithInternetExplorer;

    /**
     * The Enterprise Cloud Print Discovery End Point.
     * Endpoint for discovering cloud printers.
     */
    @SerializedName("enterpriseCloudPrintDiscoveryEndPoint")
    @Expose
    public String enterpriseCloudPrintDiscoveryEndPoint;

    /**
     * The Enterprise Cloud Print Discovery Max Limit.
     * Maximum number of printers that should be queried from a discovery endpoint. This is a mobile only setting. Valid values 1 to 65535
     */
    @SerializedName("enterpriseCloudPrintDiscoveryMaxLimit")
    @Expose
    public Integer enterpriseCloudPrintDiscoveryMaxLimit;

    /**
     * The Enterprise Cloud Print Mopria Discovery Resource Identifier.
     * OAuth resource URI for printer discovery service as configured in Azure portal.
     */
    @SerializedName("enterpriseCloudPrintMopriaDiscoveryResourceIdentifier")
    @Expose
    public String enterpriseCloudPrintMopriaDiscoveryResourceIdentifier;

    /**
     * The Enterprise Cloud Print OAuth Authority.
     * Authentication endpoint for acquiring OAuth tokens.
     */
    @SerializedName("enterpriseCloudPrintOAuthAuthority")
    @Expose
    public String enterpriseCloudPrintOAuthAuthority;

    /**
     * The Enterprise Cloud Print OAuth Client Identifier.
     * GUID of a client application authorized to retrieve OAuth tokens from the OAuth Authority.
     */
    @SerializedName("enterpriseCloudPrintOAuthClientIdentifier")
    @Expose
    public String enterpriseCloudPrintOAuthClientIdentifier;

    /**
     * The Enterprise Cloud Print Resource Identifier.
     * OAuth resource URI for print service as configured in the Azure portal.
     */
    @SerializedName("enterpriseCloudPrintResourceIdentifier")
    @Expose
    public String enterpriseCloudPrintResourceIdentifier;

    /**
     * The Experience Block Device Discovery.
     * Indicates whether or not to enable device discovery UX.
     */
    @SerializedName("experienceBlockDeviceDiscovery")
    @Expose
    public Boolean experienceBlockDeviceDiscovery;

    /**
     * The Experience Block Error Dialog When No SIM.
     * Indicates whether or not to allow the error dialog from displaying if no SIM card is detected.
     */
    @SerializedName("experienceBlockErrorDialogWhenNoSIM")
    @Expose
    public Boolean experienceBlockErrorDialogWhenNoSIM;

    /**
     * The Experience Block Task Switcher.
     * Indicates whether or not to enable task switching on the device.
     */
    @SerializedName("experienceBlockTaskSwitcher")
    @Expose
    public Boolean experienceBlockTaskSwitcher;

    /**
     * The Game Dvr Blocked.
     * Indicates whether or not to block DVR and broadcasting.
     */
    @SerializedName("gameDvrBlocked")
    @Expose
    public Boolean gameDvrBlocked;

    /**
     * The Internet Sharing Blocked.
     * Indicates whether or not to Block the user from using internet sharing.
     */
    @SerializedName("internetSharingBlocked")
    @Expose
    public Boolean internetSharingBlocked;

    /**
     * The Location Services Blocked.
     * Indicates whether or not to Block the user from location services.
     */
    @SerializedName("locationServicesBlocked")
    @Expose
    public Boolean locationServicesBlocked;

    /**
     * The Lock Screen Allow Timeout Configuration.
     * Specify whether to show a user-configurable setting to control the screen timeout while on the lock screen of Windows 10 Mobile devices. If this policy is set to Allow, the value set by lockScreenTimeoutInSeconds is ignored.
     */
    @SerializedName("lockScreenAllowTimeoutConfiguration")
    @Expose
    public Boolean lockScreenAllowTimeoutConfiguration;

    /**
     * The Lock Screen Block Action Center Notifications.
     * Indicates whether or not to block action center notifications over lock screen.
     */
    @SerializedName("lockScreenBlockActionCenterNotifications")
    @Expose
    public Boolean lockScreenBlockActionCenterNotifications;

    /**
     * The Lock Screen Block Cortana.
     * Indicates whether or not the user can interact with Cortana using speech while the system is locked.
     */
    @SerializedName("lockScreenBlockCortana")
    @Expose
    public Boolean lockScreenBlockCortana;

    /**
     * The Lock Screen Block Toast Notifications.
     * Indicates whether to allow toast notifications above the device lock screen.
     */
    @SerializedName("lockScreenBlockToastNotifications")
    @Expose
    public Boolean lockScreenBlockToastNotifications;

    /**
     * The Lock Screen Timeout In Seconds.
     * Set the duration (in seconds) from the screen locking to the screen turning off for Windows 10 Mobile devices. Supported values are 11-1800. Valid values 11 to 1800
     */
    @SerializedName("lockScreenTimeoutInSeconds")
    @Expose
    public Integer lockScreenTimeoutInSeconds;

    /**
     * The Logon Block Fast User Switching.
     * Disables the ability to quickly switch between users that are logged on simultaneously without logging off.
     */
    @SerializedName("logonBlockFastUserSwitching")
    @Expose
    public Boolean logonBlockFastUserSwitching;

    /**
     * The Microsoft Account Blocked.
     * Indicates whether or not to Block a Microsoft account.
     */
    @SerializedName("microsoftAccountBlocked")
    @Expose
    public Boolean microsoftAccountBlocked;

    /**
     * The Microsoft Account Block Settings Sync.
     * Indicates whether or not to Block Microsoft account settings sync.
     */
    @SerializedName("microsoftAccountBlockSettingsSync")
    @Expose
    public Boolean microsoftAccountBlockSettingsSync;

    /**
     * The Network Proxy Apply Settings Device Wide.
     * If set, proxy settings will be applied to all processes and accounts in the device. Otherwise, it will be applied to the user account that’s enrolled into MDM.
     */
    @SerializedName("networkProxyApplySettingsDeviceWide")
    @Expose
    public Boolean networkProxyApplySettingsDeviceWide;

    /**
     * The Network Proxy Automatic Configuration Url.
     * Address to the proxy auto-config (PAC) script you want to use.
     */
    @SerializedName("networkProxyAutomaticConfigurationUrl")
    @Expose
    public String networkProxyAutomaticConfigurationUrl;

    /**
     * The Network Proxy Disable Auto Detect.
     * Disable automatic detection of settings. If enabled, the system will try to find the path to a proxy auto-config (PAC) script.
     */
    @SerializedName("networkProxyDisableAutoDetect")
    @Expose
    public Boolean networkProxyDisableAutoDetect;

    /**
     * The Network Proxy Server.
     * Specifies manual proxy server settings.
     */
    @SerializedName("networkProxyServer")
    @Expose
    public Windows10NetworkProxyServer networkProxyServer;

    /**
     * The Nfc Blocked.
     * Indicates whether or not to Block the user from using near field communication.
     */
    @SerializedName("nfcBlocked")
    @Expose
    public Boolean nfcBlocked;

    /**
     * The One Drive Disable File Sync.
     * Gets or sets a value allowing IT admins to prevent apps and features from working with files on OneDrive.
     */
    @SerializedName("oneDriveDisableFileSync")
    @Expose
    public Boolean oneDriveDisableFileSync;

    /**
     * The Password Block Simple.
     * Specify whether PINs or passwords such as '1111' or '1234' are allowed. For Windows 10 desktops, it also controls the use of picture passwords.
     */
    @SerializedName("passwordBlockSimple")
    @Expose
    public Boolean passwordBlockSimple;

    /**
     * The Password Expiration Days.
     * The password expiration in days. Valid values 0 to 730
     */
    @SerializedName("passwordExpirationDays")
    @Expose
    public Integer passwordExpirationDays;

    /**
     * The Password Minimum Character Set Count.
     * The number of character sets required in the password.
     */
    @SerializedName("passwordMinimumCharacterSetCount")
    @Expose
    public Integer passwordMinimumCharacterSetCount;

    /**
     * The Password Minimum Length.
     * The minimum password length. Valid values 4 to 16
     */
    @SerializedName("passwordMinimumLength")
    @Expose
    public Integer passwordMinimumLength;

    /**
     * The Password Minutes Of Inactivity Before Screen Timeout.
     * The minutes of inactivity before the screen times out.
     */
    @SerializedName("passwordMinutesOfInactivityBeforeScreenTimeout")
    @Expose
    public Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    /**
     * The Password Previous Password Block Count.
     * The number of previous passwords to prevent reuse of. Valid values 0 to 50
     */
    @SerializedName("passwordPreviousPasswordBlockCount")
    @Expose
    public Integer passwordPreviousPasswordBlockCount;

    /**
     * The Password Required.
     * Indicates whether or not to require the user to have a password.
     */
    @SerializedName("passwordRequired")
    @Expose
    public Boolean passwordRequired;

    /**
     * The Password Required Type.
     * The required password type. Possible values are: deviceDefault, alphanumeric, numeric.
     */
    @SerializedName("passwordRequiredType")
    @Expose
    public RequiredPasswordType passwordRequiredType;

    /**
     * The Password Require When Resume From Idle State.
     * Indicates whether or not to require a password upon resuming from an idle state.
     */
    @SerializedName("passwordRequireWhenResumeFromIdleState")
    @Expose
    public Boolean passwordRequireWhenResumeFromIdleState;

    /**
     * The Password Sign In Failure Count Before Factory Reset.
     * The number of sign in failures before factory reset. Valid values 0 to 999
     */
    @SerializedName("passwordSignInFailureCountBeforeFactoryReset")
    @Expose
    public Integer passwordSignInFailureCountBeforeFactoryReset;

    /**
     * The Personalization Desktop Image Url.
     * A http or https Url to a jpg, jpeg or png image that needs to be downloaded and used as the Desktop Image or a file Url to a local image on the file system that needs to used as the Desktop Image.
     */
    @SerializedName("personalizationDesktopImageUrl")
    @Expose
    public String personalizationDesktopImageUrl;

    /**
     * The Personalization Lock Screen Image Url.
     * A http or https Url to a jpg, jpeg or png image that neeeds to be downloaded and used as the Lock Screen Image or a file Url to a local image on the file system that needs to be used as the Lock Screen Image.
     */
    @SerializedName("personalizationLockScreenImageUrl")
    @Expose
    public String personalizationLockScreenImageUrl;

    /**
     * The Privacy Advertising Id.
     * Enables or disables the use of advertising ID. Added in Windows 10, version 1607. Possible values are: notConfigured, blocked, allowed.
     */
    @SerializedName("privacyAdvertisingId")
    @Expose
    public StateManagementSetting privacyAdvertisingId;

    /**
     * The Privacy Auto Accept Pairing And Consent Prompts.
     * Indicates whether or not to allow the automatic acceptance of the pairing and privacy user consent dialog when launching apps.
     */
    @SerializedName("privacyAutoAcceptPairingAndConsentPrompts")
    @Expose
    public Boolean privacyAutoAcceptPairingAndConsentPrompts;

    /**
     * The Privacy Block Input Personalization.
     * Indicates whether or not to block the usage of cloud based speech services for Cortana, Dictation, or Store applications.
     */
    @SerializedName("privacyBlockInputPersonalization")
    @Expose
    public Boolean privacyBlockInputPersonalization;

    /**
     * The Reset Protection Mode Blocked.
     * Indicates whether or not to Block the user from reset protection mode.
     */
    @SerializedName("resetProtectionModeBlocked")
    @Expose
    public Boolean resetProtectionModeBlocked;

    /**
     * The Safe Search Filter.
     * Specifies what filter level of safe search is required. Possible values are: userDefined, strict, moderate.
     */
    @SerializedName("safeSearchFilter")
    @Expose
    public SafeSearchFilterType safeSearchFilter;

    /**
     * The Screen Capture Blocked.
     * Indicates whether or not to Block the user from taking Screenshots.
     */
    @SerializedName("screenCaptureBlocked")
    @Expose
    public Boolean screenCaptureBlocked;

    /**
     * The Search Block Diacritics.
     * Specifies if search can use diacritics.
     */
    @SerializedName("searchBlockDiacritics")
    @Expose
    public Boolean searchBlockDiacritics;

    /**
     * The Search Disable Auto Language Detection.
     * Specifies whether to use automatic language detection when indexing content and properties.
     */
    @SerializedName("searchDisableAutoLanguageDetection")
    @Expose
    public Boolean searchDisableAutoLanguageDetection;

    /**
     * The Search Disable Indexer Backoff.
     * Indicates whether or not to disable the search indexer backoff feature.
     */
    @SerializedName("searchDisableIndexerBackoff")
    @Expose
    public Boolean searchDisableIndexerBackoff;

    /**
     * The Search Disable Indexing Encrypted Items.
     * Indicates whether or not to block indexing of WIP-protected items to prevent them from appearing in search results for Cortana or Explorer.
     */
    @SerializedName("searchDisableIndexingEncryptedItems")
    @Expose
    public Boolean searchDisableIndexingEncryptedItems;

    /**
     * The Search Disable Indexing Removable Drive.
     * Indicates whether or not to allow users to add locations on removable drives to libraries and to be indexed.
     */
    @SerializedName("searchDisableIndexingRemovableDrive")
    @Expose
    public Boolean searchDisableIndexingRemovableDrive;

    /**
     * The Search Enable Automatic Index Size Manangement.
     * Specifies minimum amount of hard drive space on the same drive as the index location before indexing stops.
     */
    @SerializedName("searchEnableAutomaticIndexSizeManangement")
    @Expose
    public Boolean searchEnableAutomaticIndexSizeManangement;

    /**
     * The Search Enable Remote Queries.
     * Indicates whether or not to block remote queries of this computer’s index.
     */
    @SerializedName("searchEnableRemoteQueries")
    @Expose
    public Boolean searchEnableRemoteQueries;

    /**
     * The Settings Block Accounts Page.
     * Indicates whether or not to block access to Accounts in Settings app.
     */
    @SerializedName("settingsBlockAccountsPage")
    @Expose
    public Boolean settingsBlockAccountsPage;

    /**
     * The Settings Block Add Provisioning Package.
     * Indicates whether or not to block the user from installing provisioning packages.
     */
    @SerializedName("settingsBlockAddProvisioningPackage")
    @Expose
    public Boolean settingsBlockAddProvisioningPackage;

    /**
     * The Settings Block Apps Page.
     * Indicates whether or not to block access to Apps in Settings app.
     */
    @SerializedName("settingsBlockAppsPage")
    @Expose
    public Boolean settingsBlockAppsPage;

    /**
     * The Settings Block Change Language.
     * Indicates whether or not to block the user from changing the language settings.
     */
    @SerializedName("settingsBlockChangeLanguage")
    @Expose
    public Boolean settingsBlockChangeLanguage;

    /**
     * The Settings Block Change Power Sleep.
     * Indicates whether or not to block the user from changing power and sleep settings.
     */
    @SerializedName("settingsBlockChangePowerSleep")
    @Expose
    public Boolean settingsBlockChangePowerSleep;

    /**
     * The Settings Block Change Region.
     * Indicates whether or not to block the user from changing the region settings.
     */
    @SerializedName("settingsBlockChangeRegion")
    @Expose
    public Boolean settingsBlockChangeRegion;

    /**
     * The Settings Block Change System Time.
     * Indicates whether or not to block the user from changing date and time settings.
     */
    @SerializedName("settingsBlockChangeSystemTime")
    @Expose
    public Boolean settingsBlockChangeSystemTime;

    /**
     * The Settings Block Devices Page.
     * Indicates whether or not to block access to Devices in Settings app.
     */
    @SerializedName("settingsBlockDevicesPage")
    @Expose
    public Boolean settingsBlockDevicesPage;

    /**
     * The Settings Block Ease Of Access Page.
     * Indicates whether or not to block access to Ease of Access in Settings app.
     */
    @SerializedName("settingsBlockEaseOfAccessPage")
    @Expose
    public Boolean settingsBlockEaseOfAccessPage;

    /**
     * The Settings Block Edit Device Name.
     * Indicates whether or not to block the user from editing the device name.
     */
    @SerializedName("settingsBlockEditDeviceName")
    @Expose
    public Boolean settingsBlockEditDeviceName;

    /**
     * The Settings Block Gaming Page.
     * Indicates whether or not to block access to Gaming in Settings app.
     */
    @SerializedName("settingsBlockGamingPage")
    @Expose
    public Boolean settingsBlockGamingPage;

    /**
     * The Settings Block Network Internet Page.
     * Indicates whether or not to block access to Network &amp; Internet in Settings app.
     */
    @SerializedName("settingsBlockNetworkInternetPage")
    @Expose
    public Boolean settingsBlockNetworkInternetPage;

    /**
     * The Settings Block Personalization Page.
     * Indicates whether or not to block access to Personalization in Settings app.
     */
    @SerializedName("settingsBlockPersonalizationPage")
    @Expose
    public Boolean settingsBlockPersonalizationPage;

    /**
     * The Settings Block Privacy Page.
     * Indicates whether or not to block access to Privacy in Settings app.
     */
    @SerializedName("settingsBlockPrivacyPage")
    @Expose
    public Boolean settingsBlockPrivacyPage;

    /**
     * The Settings Block Remove Provisioning Package.
     * Indicates whether or not to block the runtime configuration agent from removing provisioning packages.
     */
    @SerializedName("settingsBlockRemoveProvisioningPackage")
    @Expose
    public Boolean settingsBlockRemoveProvisioningPackage;

    /**
     * The Settings Block Settings App.
     * Indicates whether or not to block access to Settings app.
     */
    @SerializedName("settingsBlockSettingsApp")
    @Expose
    public Boolean settingsBlockSettingsApp;

    /**
     * The Settings Block System Page.
     * Indicates whether or not to block access to System in Settings app.
     */
    @SerializedName("settingsBlockSystemPage")
    @Expose
    public Boolean settingsBlockSystemPage;

    /**
     * The Settings Block Time Language Page.
     * Indicates whether or not to block access to Time &amp; Language in Settings app.
     */
    @SerializedName("settingsBlockTimeLanguagePage")
    @Expose
    public Boolean settingsBlockTimeLanguagePage;

    /**
     * The Settings Block Update Security Page.
     * Indicates whether or not to block access to Update &amp; Security in Settings app.
     */
    @SerializedName("settingsBlockUpdateSecurityPage")
    @Expose
    public Boolean settingsBlockUpdateSecurityPage;

    /**
     * The Shared User App Data Allowed.
     * Indicates whether or not to block multiple users of the same app to share data.
     */
    @SerializedName("sharedUserAppDataAllowed")
    @Expose
    public Boolean sharedUserAppDataAllowed;

    /**
     * The Smart Screen Block Prompt Override.
     * Indicates whether or not users can override SmartScreen Filter warnings about potentially malicious websites.
     */
    @SerializedName("smartScreenBlockPromptOverride")
    @Expose
    public Boolean smartScreenBlockPromptOverride;

    /**
     * The Smart Screen Block Prompt Override For Files.
     * Indicates whether or not users can override the SmartScreen Filter warnings about downloading unverified files
     */
    @SerializedName("smartScreenBlockPromptOverrideForFiles")
    @Expose
    public Boolean smartScreenBlockPromptOverrideForFiles;

    /**
     * The Smart Screen Enable App Install Control.
     * Allows IT Admins to control whether users are allowed to install apps from places other than the Store.
     */
    @SerializedName("smartScreenEnableAppInstallControl")
    @Expose
    public Boolean smartScreenEnableAppInstallControl;

    /**
     * The Start Block Unpinning Apps From Taskbar.
     * Indicates whether or not to block the user from unpinning apps from taskbar.
     */
    @SerializedName("startBlockUnpinningAppsFromTaskbar")
    @Expose
    public Boolean startBlockUnpinningAppsFromTaskbar;

    /**
     * The Start Menu App List Visibility.
     * Setting the value of this collapses the app list, removes the app list entirely, or disables the corresponding toggle in the Settings app. Possible values are: userDefined, collapse, remove, disableSettingsApp.
     */
    @SerializedName("startMenuAppListVisibility")
    @Expose
    public EnumSet<WindowsStartMenuAppListVisibilityType> startMenuAppListVisibility;

    /**
     * The Start Menu Hide Change Account Settings.
     * Enabling this policy hides the change account setting from appearing in the user tile in the start menu.
     */
    @SerializedName("startMenuHideChangeAccountSettings")
    @Expose
    public Boolean startMenuHideChangeAccountSettings;

    /**
     * The Start Menu Hide Frequently Used Apps.
     * Enabling this policy hides the most used apps from appearing on the start menu and disables the corresponding toggle in the Settings app.
     */
    @SerializedName("startMenuHideFrequentlyUsedApps")
    @Expose
    public Boolean startMenuHideFrequentlyUsedApps;

    /**
     * The Start Menu Hide Hibernate.
     * Enabling this policy hides hibernate from appearing in the power button in the start menu.
     */
    @SerializedName("startMenuHideHibernate")
    @Expose
    public Boolean startMenuHideHibernate;

    /**
     * The Start Menu Hide Lock.
     * Enabling this policy hides lock from appearing in the user tile in the start menu.
     */
    @SerializedName("startMenuHideLock")
    @Expose
    public Boolean startMenuHideLock;

    /**
     * The Start Menu Hide Power Button.
     * Enabling this policy hides the power button from appearing in the start menu.
     */
    @SerializedName("startMenuHidePowerButton")
    @Expose
    public Boolean startMenuHidePowerButton;

    /**
     * The Start Menu Hide Recent Jump Lists.
     * Enabling this policy hides recent jump lists from appearing on the start menu/taskbar and disables the corresponding toggle in the Settings app.
     */
    @SerializedName("startMenuHideRecentJumpLists")
    @Expose
    public Boolean startMenuHideRecentJumpLists;

    /**
     * The Start Menu Hide Recently Added Apps.
     * Enabling this policy hides recently added apps from appearing on the start menu and disables the corresponding toggle in the Settings app.
     */
    @SerializedName("startMenuHideRecentlyAddedApps")
    @Expose
    public Boolean startMenuHideRecentlyAddedApps;

    /**
     * The Start Menu Hide Restart Options.
     * Enabling this policy hides 'Restart/Update and Restart' from appearing in the power button in the start menu.
     */
    @SerializedName("startMenuHideRestartOptions")
    @Expose
    public Boolean startMenuHideRestartOptions;

    /**
     * The Start Menu Hide Shut Down.
     * Enabling this policy hides shut down/update and shut down from appearing in the power button in the start menu.
     */
    @SerializedName("startMenuHideShutDown")
    @Expose
    public Boolean startMenuHideShutDown;

    /**
     * The Start Menu Hide Sign Out.
     * Enabling this policy hides sign out from appearing in the user tile in the start menu.
     */
    @SerializedName("startMenuHideSignOut")
    @Expose
    public Boolean startMenuHideSignOut;

    /**
     * The Start Menu Hide Sleep.
     * Enabling this policy hides sleep from appearing in the power button in the start menu.
     */
    @SerializedName("startMenuHideSleep")
    @Expose
    public Boolean startMenuHideSleep;

    /**
     * The Start Menu Hide Switch Account.
     * Enabling this policy hides switch account from appearing in the user tile in the start menu.
     */
    @SerializedName("startMenuHideSwitchAccount")
    @Expose
    public Boolean startMenuHideSwitchAccount;

    /**
     * The Start Menu Hide User Tile.
     * Enabling this policy hides the user tile from appearing in the start menu.
     */
    @SerializedName("startMenuHideUserTile")
    @Expose
    public Boolean startMenuHideUserTile;

    /**
     * The Start Menu Layout Edge Assets Xml.
     * This policy setting allows you to import Edge assets to be used with startMenuLayoutXml policy. Start layout can contain secondary tile from Edge app which looks for Edge local asset file. Edge local asset would not exist and cause Edge secondary tile to appear empty in this case. This policy only gets applied when startMenuLayoutXml policy is modified. The value should be a UTF-8 Base64 encoded byte array.
     */
    @SerializedName("startMenuLayoutEdgeAssetsXml")
    @Expose
    public byte[] startMenuLayoutEdgeAssetsXml;

    /**
     * The Start Menu Layout Xml.
     * Allows admins to override the default Start menu layout and prevents the user from changing it. The layout is modified by specifying an XML file based on a layout modification schema. XML needs to be in a UTF8 encoded byte array format.
     */
    @SerializedName("startMenuLayoutXml")
    @Expose
    public byte[] startMenuLayoutXml;

    /**
     * The Start Menu Mode.
     * Allows admins to decide how the Start menu is displayed. Possible values are: userDefined, fullScreen, nonFullScreen.
     */
    @SerializedName("startMenuMode")
    @Expose
    public WindowsStartMenuModeType startMenuMode;

    /**
     * The Start Menu Pinned Folder Documents.
     * Enforces the visibility (Show/Hide) of the Documents folder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderDocuments")
    @Expose
    public VisibilitySetting startMenuPinnedFolderDocuments;

    /**
     * The Start Menu Pinned Folder Downloads.
     * Enforces the visibility (Show/Hide) of the Downloads folder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderDownloads")
    @Expose
    public VisibilitySetting startMenuPinnedFolderDownloads;

    /**
     * The Start Menu Pinned Folder File Explorer.
     * Enforces the visibility (Show/Hide) of the FileExplorer shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderFileExplorer")
    @Expose
    public VisibilitySetting startMenuPinnedFolderFileExplorer;

    /**
     * The Start Menu Pinned Folder Home Group.
     * Enforces the visibility (Show/Hide) of the HomeGroup folder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderHomeGroup")
    @Expose
    public VisibilitySetting startMenuPinnedFolderHomeGroup;

    /**
     * The Start Menu Pinned Folder Music.
     * Enforces the visibility (Show/Hide) of the Music folder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderMusic")
    @Expose
    public VisibilitySetting startMenuPinnedFolderMusic;

    /**
     * The Start Menu Pinned Folder Network.
     * Enforces the visibility (Show/Hide) of the Network folder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderNetwork")
    @Expose
    public VisibilitySetting startMenuPinnedFolderNetwork;

    /**
     * The Start Menu Pinned Folder Personal Folder.
     * Enforces the visibility (Show/Hide) of the PersonalFolder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderPersonalFolder")
    @Expose
    public VisibilitySetting startMenuPinnedFolderPersonalFolder;

    /**
     * The Start Menu Pinned Folder Pictures.
     * Enforces the visibility (Show/Hide) of the Pictures folder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderPictures")
    @Expose
    public VisibilitySetting startMenuPinnedFolderPictures;

    /**
     * The Start Menu Pinned Folder Settings.
     * Enforces the visibility (Show/Hide) of the Settings folder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderSettings")
    @Expose
    public VisibilitySetting startMenuPinnedFolderSettings;

    /**
     * The Start Menu Pinned Folder Videos.
     * Enforces the visibility (Show/Hide) of the Videos folder shortcut on the Start menu. Possible values are: notConfigured, hide, show.
     */
    @SerializedName("startMenuPinnedFolderVideos")
    @Expose
    public VisibilitySetting startMenuPinnedFolderVideos;

    /**
     * The Storage Block Removable Storage.
     * Indicates whether or not to Block the user from using removable storage.
     */
    @SerializedName("storageBlockRemovableStorage")
    @Expose
    public Boolean storageBlockRemovableStorage;

    /**
     * The Storage Require Mobile Device Encryption.
     * Indicating whether or not to require encryption on a mobile device.
     */
    @SerializedName("storageRequireMobileDeviceEncryption")
    @Expose
    public Boolean storageRequireMobileDeviceEncryption;

    /**
     * The Storage Restrict App Data To System Volume.
     * Indicates whether application data is restricted to the system drive.
     */
    @SerializedName("storageRestrictAppDataToSystemVolume")
    @Expose
    public Boolean storageRestrictAppDataToSystemVolume;

    /**
     * The Storage Restrict App Install To System Volume.
     * Indicates whether the installation of applications is restricted to the system drive.
     */
    @SerializedName("storageRestrictAppInstallToSystemVolume")
    @Expose
    public Boolean storageRestrictAppInstallToSystemVolume;

    /**
     * The Tenant Lockdown Require Network During Out Of Box Experience.
     * Whether the device is required to connect to the network.
     */
    @SerializedName("tenantLockdownRequireNetworkDuringOutOfBoxExperience")
    @Expose
    public Boolean tenantLockdownRequireNetworkDuringOutOfBoxExperience;

    /**
     * The Usb Blocked.
     * Indicates whether or not to Block the user from USB connection.
     */
    @SerializedName("usbBlocked")
    @Expose
    public Boolean usbBlocked;

    /**
     * The Voice Recording Blocked.
     * Indicates whether or not to Block the user from voice recording.
     */
    @SerializedName("voiceRecordingBlocked")
    @Expose
    public Boolean voiceRecordingBlocked;

    /**
     * The Web Rtc Block Localhost Ip Address.
     * Indicates whether or not user's localhost IP address is displayed while making phone calls using the WebRTC
     */
    @SerializedName("webRtcBlockLocalhostIpAddress")
    @Expose
    public Boolean webRtcBlockLocalhostIpAddress;

    /**
     * The Wi Fi Block Automatic Connect Hotspots.
     * Indicating whether or not to block automatically connecting to Wi-Fi hotspots. Has no impact if Wi-Fi is blocked.
     */
    @SerializedName("wiFiBlockAutomaticConnectHotspots")
    @Expose
    public Boolean wiFiBlockAutomaticConnectHotspots;

    /**
     * The Wi Fi Blocked.
     * Indicates whether or not to Block the user from using Wi-Fi.
     */
    @SerializedName("wiFiBlocked")
    @Expose
    public Boolean wiFiBlocked;

    /**
     * The Wi Fi Block Manual Configuration.
     * Indicates whether or not to Block the user from using Wi-Fi manual configuration.
     */
    @SerializedName("wiFiBlockManualConfiguration")
    @Expose
    public Boolean wiFiBlockManualConfiguration;

    /**
     * The Wi Fi Scan Interval.
     * Specify how often devices scan for Wi-Fi networks. Supported values are 1-500, where 100 = default, and 500 = low frequency. Valid values 1 to 500
     */
    @SerializedName("wiFiScanInterval")
    @Expose
    public Integer wiFiScanInterval;

    /**
     * The Windows Spotlight Block Consumer Specific Features.
     * Allows IT admins to block experiences that are typically for consumers only, such as Start suggestions, Membership notifications, Post-OOBE app install and redirect tiles.
     */
    @SerializedName("windowsSpotlightBlockConsumerSpecificFeatures")
    @Expose
    public Boolean windowsSpotlightBlockConsumerSpecificFeatures;

    /**
     * The Windows Spotlight Blocked.
     * Allows IT admins to turn off all Windows Spotlight features
     */
    @SerializedName("windowsSpotlightBlocked")
    @Expose
    public Boolean windowsSpotlightBlocked;

    /**
     * The Windows Spotlight Block On Action Center.
     * Block suggestions from Microsoft that show after each OS clean install, upgrade or in an on-going basis to introduce users to what is new or changed
     */
    @SerializedName("windowsSpotlightBlockOnActionCenter")
    @Expose
    public Boolean windowsSpotlightBlockOnActionCenter;

    /**
     * The Windows Spotlight Block Tailored Experiences.
     * Block personalized content in Windows spotlight based on user’s device usage.
     */
    @SerializedName("windowsSpotlightBlockTailoredExperiences")
    @Expose
    public Boolean windowsSpotlightBlockTailoredExperiences;

    /**
     * The Windows Spotlight Block Third Party Notifications.
     * Block third party content delivered via Windows Spotlight
     */
    @SerializedName("windowsSpotlightBlockThirdPartyNotifications")
    @Expose
    public Boolean windowsSpotlightBlockThirdPartyNotifications;

    /**
     * The Windows Spotlight Block Welcome Experience.
     * Block Windows Spotlight Windows welcome experience
     */
    @SerializedName("windowsSpotlightBlockWelcomeExperience")
    @Expose
    public Boolean windowsSpotlightBlockWelcomeExperience;

    /**
     * The Windows Spotlight Block Windows Tips.
     * Allows IT admins to turn off the popup of Windows Tips.
     */
    @SerializedName("windowsSpotlightBlockWindowsTips")
    @Expose
    public Boolean windowsSpotlightBlockWindowsTips;

    /**
     * The Windows Spotlight Configure On Lock Screen.
     * Specifies the type of Spotlight. Possible values are: notConfigured, disabled, enabled.
     */
    @SerializedName("windowsSpotlightConfigureOnLockScreen")
    @Expose
    public WindowsSpotlightEnablementSettings windowsSpotlightConfigureOnLockScreen;

    /**
     * The Windows Store Block Auto Update.
     * Indicates whether or not to block automatic update of apps from Windows Store.
     */
    @SerializedName("windowsStoreBlockAutoUpdate")
    @Expose
    public Boolean windowsStoreBlockAutoUpdate;

    /**
     * The Windows Store Blocked.
     * Indicates whether or not to Block the user from using the Windows store.
     */
    @SerializedName("windowsStoreBlocked")
    @Expose
    public Boolean windowsStoreBlocked;

    /**
     * The Windows Store Enable Private Store Only.
     * Indicates whether or not to enable Private Store Only.
     */
    @SerializedName("windowsStoreEnablePrivateStoreOnly")
    @Expose
    public Boolean windowsStoreEnablePrivateStoreOnly;

    /**
     * The Wireless Display Block Projection To This Device.
     * Indicates whether or not to allow other devices from discovering this PC for projection.
     */
    @SerializedName("wirelessDisplayBlockProjectionToThisDevice")
    @Expose
    public Boolean wirelessDisplayBlockProjectionToThisDevice;

    /**
     * The Wireless Display Block User Input From Receiver.
     * Indicates whether or not to allow user input from wireless display receiver.
     */
    @SerializedName("wirelessDisplayBlockUserInputFromReceiver")
    @Expose
    public Boolean wirelessDisplayBlockUserInputFromReceiver;

    /**
     * The Wireless Display Require Pin For Pairing.
     * Indicates whether or not to require a PIN for new devices to initiate pairing.
     */
    @SerializedName("wirelessDisplayRequirePinForPairing")
    @Expose
    public Boolean wirelessDisplayRequirePinForPairing;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
