// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.ICallChangeScreenSharingRoleRequest;
import com.microsoft.graph.requests.extensions.CallChangeScreenSharingRoleRequest;
import com.microsoft.graph.models.generated.ScreenSharingRole;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Change Screen Sharing Role Request Builder.
 */
public class CallChangeScreenSharingRoleRequestBuilder extends BaseActionRequestBuilder implements ICallChangeScreenSharingRoleRequestBuilder {

    /**
     * The request builder for this CallChangeScreenSharingRole
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param role the role
     */
    public CallChangeScreenSharingRoleRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final ScreenSharingRole role) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("role", role);
    }

    /**
     * Creates the ICallChangeScreenSharingRoleRequest
     *
     * @param requestOptions the options for the request
     * @return the ICallChangeScreenSharingRoleRequest instance
     */
    public ICallChangeScreenSharingRoleRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the ICallChangeScreenSharingRoleRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the ICallChangeScreenSharingRoleRequest instance
     */
    public ICallChangeScreenSharingRoleRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        CallChangeScreenSharingRoleRequest request = new CallChangeScreenSharingRoleRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("role")) {
            request.body.role = getParameter("role");
        }

        return request;
    }
}
