// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DirectoryObjectPartnerReference;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.DirectoryObjectPartnerReference;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Directory Object Partner Reference Reference Request.
 */
public interface IDirectoryObjectPartnerReferenceReferenceRequest extends IHttpRequest {

    void delete(final ICallback<? super DirectoryObjectPartnerReference> callback);

    DirectoryObjectPartnerReference delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDirectoryObjectPartnerReferenceReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDirectoryObjectPartnerReferenceReferenceRequest expand(final String value);

    /**
     * Puts the DirectoryObjectPartnerReference
     *
     * @param srcDirectoryObjectPartnerReference the DirectoryObjectPartnerReference to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(DirectoryObjectPartnerReference srcDirectoryObjectPartnerReference, final ICallback<? super DirectoryObjectPartnerReference> callback);

    /**
     * Puts the DirectoryObjectPartnerReference
     *
     * @param srcDirectoryObjectPartnerReference the DirectoryObjectPartnerReference to PUT
     * @return the DirectoryObjectPartnerReference
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    DirectoryObjectPartnerReference put(DirectoryObjectPartnerReference srcDirectoryObjectPartnerReference) throws ClientException;
}
