// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DirectoryObjectPartnerReference;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.DirectoryObjectPartnerReference;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Directory Object Partner Reference With Reference Request.
 */
public interface IDirectoryObjectPartnerReferenceWithReferenceRequest extends IHttpRequest {

    void post(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference, final IJsonBackedObject payload, final ICallback<? super DirectoryObjectPartnerReference> callback);

    DirectoryObjectPartnerReference post(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<? super DirectoryObjectPartnerReference> callback);

    DirectoryObjectPartnerReference get() throws ClientException;

	void delete(final ICallback<? super DirectoryObjectPartnerReference> callback);

	void delete() throws ClientException;

	void patch(final DirectoryObjectPartnerReference sourceDirectoryObjectPartnerReference, final ICallback<? super DirectoryObjectPartnerReference> callback);

	DirectoryObjectPartnerReference patch(final DirectoryObjectPartnerReference sourceDirectoryObjectPartnerReference) throws ClientException;

    IDirectoryObjectPartnerReferenceWithReferenceRequest select(final String value);

    IDirectoryObjectPartnerReferenceWithReferenceRequest expand(final String value);

}
