// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.PlayPromptOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Play Prompt Operation Request.
 */
public interface IPlayPromptOperationRequest extends IHttpRequest {

    /**
     * Gets the PlayPromptOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super PlayPromptOperation> callback);

    /**
     * Gets the PlayPromptOperation from the service
     *
     * @return the PlayPromptOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PlayPromptOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super PlayPromptOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this PlayPromptOperation with a source
     *
     * @param sourcePlayPromptOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final PlayPromptOperation sourcePlayPromptOperation, final ICallback<? super PlayPromptOperation> callback);

    /**
     * Patches this PlayPromptOperation with a source
     *
     * @param sourcePlayPromptOperation the source object with updates
     * @return the updated PlayPromptOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PlayPromptOperation patch(final PlayPromptOperation sourcePlayPromptOperation) throws ClientException;

    /**
     * Posts a PlayPromptOperation with a new object
     *
     * @param newPlayPromptOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final PlayPromptOperation newPlayPromptOperation, final ICallback<? super PlayPromptOperation> callback);

    /**
     * Posts a PlayPromptOperation with a new object
     *
     * @param newPlayPromptOperation the new object to create
     * @return the created PlayPromptOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PlayPromptOperation post(final PlayPromptOperation newPlayPromptOperation) throws ClientException;

    /**
     * Posts a PlayPromptOperation with a new object
     *
     * @param newPlayPromptOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final PlayPromptOperation newPlayPromptOperation, final ICallback<? super PlayPromptOperation> callback);

    /**
     * Posts a PlayPromptOperation with a new object
     *
     * @param newPlayPromptOperation the object to create/update
     * @return the created PlayPromptOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    PlayPromptOperation put(final PlayPromptOperation newPlayPromptOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IPlayPromptOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IPlayPromptOperationRequest expand(final String value);

}

