/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.ItemActivityStat;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IItemActivityStatCollectionPage;
import com.microsoft.graph.requests.extensions.IItemActivityStatCollectionRequest;
import com.microsoft.graph.requests.extensions.ItemActivityStatCollectionPage;
import com.microsoft.graph.requests.extensions.ItemActivityStatCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ItemActivityStatCollectionResponse;
import com.microsoft.graph.requests.extensions.ItemActivityStatRequestBuilder;
import java.util.List;

public class ItemActivityStatCollectionRequest
extends BaseCollectionRequest<ItemActivityStatCollectionResponse, IItemActivityStatCollectionPage>
implements IItemActivityStatCollectionRequest {
    public ItemActivityStatCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ItemActivityStatCollectionResponse.class, IItemActivityStatCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IItemActivityStatCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(ItemActivityStatCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IItemActivityStatCollectionPage get() throws ClientException {
        ItemActivityStatCollectionResponse response = (ItemActivityStatCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(ItemActivityStat newItemActivityStat, ICallback<? super ItemActivityStat> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new ItemActivityStatRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newItemActivityStat, callback);
    }

    @Override
    public ItemActivityStat post(ItemActivityStat newItemActivityStat) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new ItemActivityStatRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newItemActivityStat);
    }

    @Override
    public IItemActivityStatCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IItemActivityStatCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IItemActivityStatCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IItemActivityStatCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IItemActivityStatCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IItemActivityStatCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IItemActivityStatCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IItemActivityStatCollectionPage buildFromResponse(ItemActivityStatCollectionResponse response) {
        ItemActivityStatCollectionRequestBuilder builder = response.nextLink != null ? new ItemActivityStatCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        ItemActivityStatCollectionPage page = new ItemActivityStatCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

