/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.UserActivity;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IUserActivityCollectionPage;
import com.microsoft.graph.requests.extensions.IUserActivityCollectionRequest;
import com.microsoft.graph.requests.extensions.UserActivityCollectionPage;
import com.microsoft.graph.requests.extensions.UserActivityCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UserActivityCollectionResponse;
import com.microsoft.graph.requests.extensions.UserActivityRequestBuilder;
import java.util.List;

public class UserActivityCollectionRequest
extends BaseCollectionRequest<UserActivityCollectionResponse, IUserActivityCollectionPage>
implements IUserActivityCollectionRequest {
    public UserActivityCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserActivityCollectionResponse.class, IUserActivityCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IUserActivityCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(UserActivityCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IUserActivityCollectionPage get() throws ClientException {
        UserActivityCollectionResponse response = (UserActivityCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(UserActivity newUserActivity, ICallback<? super UserActivity> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new UserActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newUserActivity, callback);
    }

    @Override
    public UserActivity post(UserActivity newUserActivity) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new UserActivityRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newUserActivity);
    }

    @Override
    public IUserActivityCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IUserActivityCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IUserActivityCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IUserActivityCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IUserActivityCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IUserActivityCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IUserActivityCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IUserActivityCollectionPage buildFromResponse(UserActivityCollectionResponse response) {
        UserActivityCollectionRequestBuilder builder = response.nextLink != null ? new UserActivityCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        UserActivityCollectionPage page = new UserActivityCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

