/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.models.extensions.AttendeeBase;
import com.microsoft.graph.models.extensions.LocationConstraint;
import com.microsoft.graph.models.extensions.TimeConstraint;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.extensions.IUserFindMeetingTimesRequest;
import com.microsoft.graph.requests.extensions.IUserFindMeetingTimesRequestBuilder;
import com.microsoft.graph.requests.extensions.UserFindMeetingTimesRequest;
import java.util.List;
import javax.xml.datatype.Duration;

public class UserFindMeetingTimesRequestBuilder
extends BaseActionRequestBuilder
implements IUserFindMeetingTimesRequestBuilder {
    public UserFindMeetingTimesRequestBuilder(String requestUrl, IBaseClient client, List<? extends Option> requestOptions, List<AttendeeBase> attendees, LocationConstraint locationConstraint, TimeConstraint timeConstraint, Duration meetingDuration, Integer maxCandidates, Boolean isOrganizerOptional, Boolean returnSuggestionReasons, Double minimumAttendeePercentage) {
        super(requestUrl, client, requestOptions);
        this.bodyParams.put("attendees", attendees);
        this.bodyParams.put("locationConstraint", locationConstraint);
        this.bodyParams.put("timeConstraint", timeConstraint);
        this.bodyParams.put("meetingDuration", meetingDuration);
        this.bodyParams.put("maxCandidates", maxCandidates);
        this.bodyParams.put("isOrganizerOptional", isOrganizerOptional);
        this.bodyParams.put("returnSuggestionReasons", returnSuggestionReasons);
        this.bodyParams.put("minimumAttendeePercentage", minimumAttendeePercentage);
    }

    @Override
    public IUserFindMeetingTimesRequest buildRequest(Option ... requestOptions) {
        return this.buildRequest(this.getOptions(requestOptions));
    }

    @Override
    public IUserFindMeetingTimesRequest buildRequest(List<? extends Option> requestOptions) {
        UserFindMeetingTimesRequest request = new UserFindMeetingTimesRequest(this.getRequestUrl(), this.getClient(), requestOptions);
        if (this.hasParameter("attendees")) {
            request.body.attendees = (List)this.getParameter("attendees");
        }
        if (this.hasParameter("locationConstraint")) {
            request.body.locationConstraint = (LocationConstraint)this.getParameter("locationConstraint");
        }
        if (this.hasParameter("timeConstraint")) {
            request.body.timeConstraint = (TimeConstraint)this.getParameter("timeConstraint");
        }
        if (this.hasParameter("meetingDuration")) {
            request.body.meetingDuration = (Duration)this.getParameter("meetingDuration");
        }
        if (this.hasParameter("maxCandidates")) {
            request.body.maxCandidates = (Integer)this.getParameter("maxCandidates");
        }
        if (this.hasParameter("isOrganizerOptional")) {
            request.body.isOrganizerOptional = (Boolean)this.getParameter("isOrganizerOptional");
        }
        if (this.hasParameter("returnSuggestionReasons")) {
            request.body.returnSuggestionReasons = (Boolean)this.getParameter("returnSuggestionReasons");
        }
        if (this.hasParameter("minimumAttendeePercentage")) {
            request.body.minimumAttendeePercentage = (Double)this.getParameter("minimumAttendeePercentage");
        }
        return request;
    }
}

