// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DirectoryObject;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Directory Object Request.
 */
public interface IDirectoryObjectRequest extends IHttpRequest {

    /**
     * Gets the DirectoryObject from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DirectoryObject> callback);

    /**
     * Gets the DirectoryObject from the service
     *
     * @return the DirectoryObject from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryObject get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DirectoryObject> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DirectoryObject with a source
     *
     * @param sourceDirectoryObject the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DirectoryObject sourceDirectoryObject, final ICallback<? super DirectoryObject> callback);

    /**
     * Patches this DirectoryObject with a source
     *
     * @param sourceDirectoryObject the source object with updates
     * @return the updated DirectoryObject
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryObject patch(final DirectoryObject sourceDirectoryObject) throws ClientException;

    /**
     * Posts a DirectoryObject with a new object
     *
     * @param newDirectoryObject the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DirectoryObject newDirectoryObject, final ICallback<? super DirectoryObject> callback);

    /**
     * Posts a DirectoryObject with a new object
     *
     * @param newDirectoryObject the new object to create
     * @return the created DirectoryObject
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryObject post(final DirectoryObject newDirectoryObject) throws ClientException;

    /**
     * Posts a DirectoryObject with a new object
     *
     * @param newDirectoryObject the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DirectoryObject newDirectoryObject, final ICallback<? super DirectoryObject> callback);

    /**
     * Posts a DirectoryObject with a new object
     *
     * @param newDirectoryObject the object to create/update
     * @return the created DirectoryObject
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DirectoryObject put(final DirectoryObject newDirectoryObject) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDirectoryObjectRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDirectoryObjectRequest expand(final String value);

}

