// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ManagedDeviceMobileAppConfigurationAssignment;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed Device Mobile App Configuration Assignment Request.
 */
public interface IManagedDeviceMobileAppConfigurationAssignmentRequest extends IHttpRequest {

    /**
     * Gets the ManagedDeviceMobileAppConfigurationAssignment from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ManagedDeviceMobileAppConfigurationAssignment> callback);

    /**
     * Gets the ManagedDeviceMobileAppConfigurationAssignment from the service
     *
     * @return the ManagedDeviceMobileAppConfigurationAssignment from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationAssignment get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ManagedDeviceMobileAppConfigurationAssignment> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ManagedDeviceMobileAppConfigurationAssignment with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationAssignment the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ManagedDeviceMobileAppConfigurationAssignment sourceManagedDeviceMobileAppConfigurationAssignment, final ICallback<? super ManagedDeviceMobileAppConfigurationAssignment> callback);

    /**
     * Patches this ManagedDeviceMobileAppConfigurationAssignment with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationAssignment the source object with updates
     * @return the updated ManagedDeviceMobileAppConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationAssignment patch(final ManagedDeviceMobileAppConfigurationAssignment sourceManagedDeviceMobileAppConfigurationAssignment) throws ClientException;

    /**
     * Posts a ManagedDeviceMobileAppConfigurationAssignment with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationAssignment the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ManagedDeviceMobileAppConfigurationAssignment newManagedDeviceMobileAppConfigurationAssignment, final ICallback<? super ManagedDeviceMobileAppConfigurationAssignment> callback);

    /**
     * Posts a ManagedDeviceMobileAppConfigurationAssignment with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationAssignment the new object to create
     * @return the created ManagedDeviceMobileAppConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationAssignment post(final ManagedDeviceMobileAppConfigurationAssignment newManagedDeviceMobileAppConfigurationAssignment) throws ClientException;

    /**
     * Posts a ManagedDeviceMobileAppConfigurationAssignment with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationAssignment the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ManagedDeviceMobileAppConfigurationAssignment newManagedDeviceMobileAppConfigurationAssignment, final ICallback<? super ManagedDeviceMobileAppConfigurationAssignment> callback);

    /**
     * Posts a ManagedDeviceMobileAppConfigurationAssignment with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationAssignment the object to create/update
     * @return the created ManagedDeviceMobileAppConfigurationAssignment
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationAssignment put(final ManagedDeviceMobileAppConfigurationAssignment newManagedDeviceMobileAppConfigurationAssignment) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedDeviceMobileAppConfigurationAssignmentRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedDeviceMobileAppConfigurationAssignmentRequest expand(final String value);

}

