// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.Participant;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Participant Request.
 */
public interface IParticipantRequest extends IHttpRequest {

    /**
     * Gets the Participant from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super Participant> callback);

    /**
     * Gets the Participant from the service
     *
     * @return the Participant from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Participant get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super Participant> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this Participant with a source
     *
     * @param sourceParticipant the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final Participant sourceParticipant, final ICallback<? super Participant> callback);

    /**
     * Patches this Participant with a source
     *
     * @param sourceParticipant the source object with updates
     * @return the updated Participant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Participant patch(final Participant sourceParticipant) throws ClientException;

    /**
     * Posts a Participant with a new object
     *
     * @param newParticipant the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final Participant newParticipant, final ICallback<? super Participant> callback);

    /**
     * Posts a Participant with a new object
     *
     * @param newParticipant the new object to create
     * @return the created Participant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Participant post(final Participant newParticipant) throws ClientException;

    /**
     * Posts a Participant with a new object
     *
     * @param newParticipant the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final Participant newParticipant, final ICallback<? super Participant> callback);

    /**
     * Posts a Participant with a new object
     *
     * @param newParticipant the object to create/update
     * @return the created Participant
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    Participant put(final Participant newParticipant) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IParticipantRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IParticipantRequest expand(final String value);

}

