// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ServicePrincipal;
import com.microsoft.graph.models.extensions.OrgContact;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IOrgContactCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.extensions.IOrgContactCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.OrgContactCollectionResponse;
import com.microsoft.graph.models.extensions.OrgContact;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Org Contact Collection With References Page.
 */
public class OrgContactCollectionWithReferencesPage extends BaseCollectionPage<OrgContact, IOrgContactCollectionWithReferencesRequestBuilder> implements IOrgContactCollectionWithReferencesPage {

    /**
     * A collection page for OrgContact
     *
     * @param response the serialized OrgContactCollectionResponse from the service
     * @param builder  the request builder for the next collection page
     */
    public OrgContactCollectionWithReferencesPage(final OrgContactCollectionResponse response, final IOrgContactCollectionWithReferencesRequestBuilder builder) {
        super(response.value, builder, response.additionalDataManager());
    }
}
