// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Audio.
 */
public class Audio implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Album.
     * The title of the album for this audio file.
     */
    @SerializedName(value = "album", alternate = {"Album"})
    @Expose
    public String album;

    /**
     * The Album Artist.
     * The artist named on the album for the audio file.
     */
    @SerializedName(value = "albumArtist", alternate = {"AlbumArtist"})
    @Expose
    public String albumArtist;

    /**
     * The Artist.
     * The performing artist for the audio file.
     */
    @SerializedName(value = "artist", alternate = {"Artist"})
    @Expose
    public String artist;

    /**
     * The Bitrate.
     * Bitrate expressed in kbps.
     */
    @SerializedName(value = "bitrate", alternate = {"Bitrate"})
    @Expose
    public Long bitrate;

    /**
     * The Composers.
     * The name of the composer of the audio file.
     */
    @SerializedName(value = "composers", alternate = {"Composers"})
    @Expose
    public String composers;

    /**
     * The Copyright.
     * Copyright information for the audio file.
     */
    @SerializedName(value = "copyright", alternate = {"Copyright"})
    @Expose
    public String copyright;

    /**
     * The Disc.
     * The number of the disc this audio file came from.
     */
    @SerializedName(value = "disc", alternate = {"Disc"})
    @Expose
    public Integer disc;

    /**
     * The Disc Count.
     * The total number of discs in this album.
     */
    @SerializedName(value = "discCount", alternate = {"DiscCount"})
    @Expose
    public Integer discCount;

    /**
     * The Duration.
     * Duration of the audio file, expressed in milliseconds
     */
    @SerializedName(value = "duration", alternate = {"Duration"})
    @Expose
    public Long duration;

    /**
     * The Genre.
     * The genre of this audio file.
     */
    @SerializedName(value = "genre", alternate = {"Genre"})
    @Expose
    public String genre;

    /**
     * The Has Drm.
     * Indicates if the file is protected with digital rights management.
     */
    @SerializedName(value = "hasDrm", alternate = {"HasDrm"})
    @Expose
    public Boolean hasDrm;

    /**
     * The Is Variable Bitrate.
     * Indicates if the file is encoded with a variable bitrate.
     */
    @SerializedName(value = "isVariableBitrate", alternate = {"IsVariableBitrate"})
    @Expose
    public Boolean isVariableBitrate;

    /**
     * The Title.
     * The title of the audio file.
     */
    @SerializedName(value = "title", alternate = {"Title"})
    @Expose
    public String title;

    /**
     * The Track.
     * The number of the track on the original disc for this audio file.
     */
    @SerializedName(value = "track", alternate = {"Track"})
    @Expose
    public Integer track;

    /**
     * The Track Count.
     * The total number of tracks on the original disc for this audio file.
     */
    @SerializedName(value = "trackCount", alternate = {"TrackCount"})
    @Expose
    public Integer trackCount;

    /**
     * The Year.
     * The year the audio file was recorded.
     */
    @SerializedName(value = "year", alternate = {"Year"})
    @Expose
    public Integer year;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
