// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IEventForwardRequest;
import com.microsoft.graph.requests.extensions.EventForwardRequest;
import com.microsoft.graph.models.extensions.Recipient;
import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Event Forward Request Builder.
 */
public class EventForwardRequestBuilder extends BaseActionRequestBuilder implements IEventForwardRequestBuilder {

    /**
     * The request builder for this EventForward
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param toRecipients the toRecipients
     * @param comment the comment
     */
    public EventForwardRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final java.util.List<Recipient> toRecipients, final String comment) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("toRecipients", toRecipients);
        bodyParams.put("comment", comment);
    }

    /**
     * Creates the IEventForwardRequest
     *
     * @param requestOptions the options for the request
     * @return the IEventForwardRequest instance
     */
    public IEventForwardRequest buildRequest(final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the IEventForwardRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IEventForwardRequest instance
     */
    public IEventForwardRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        EventForwardRequest request = new EventForwardRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("toRecipients")) {
            request.body.toRecipients = getParameter("toRecipients");
        }

        if (hasParameter("comment")) {
            request.body.comment = getParameter("comment");
        }

        return request;
    }
}
