// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceManagementExchangeConnector;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Management Exchange Connector Request.
 */
public interface IDeviceManagementExchangeConnectorRequest extends IHttpRequest {

    /**
     * Gets the DeviceManagementExchangeConnector from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DeviceManagementExchangeConnector> callback);

    /**
     * Gets the DeviceManagementExchangeConnector from the service
     *
     * @return the DeviceManagementExchangeConnector from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceManagementExchangeConnector get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DeviceManagementExchangeConnector> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceManagementExchangeConnector with a source
     *
     * @param sourceDeviceManagementExchangeConnector the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceManagementExchangeConnector sourceDeviceManagementExchangeConnector, final ICallback<? super DeviceManagementExchangeConnector> callback);

    /**
     * Patches this DeviceManagementExchangeConnector with a source
     *
     * @param sourceDeviceManagementExchangeConnector the source object with updates
     * @return the updated DeviceManagementExchangeConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceManagementExchangeConnector patch(final DeviceManagementExchangeConnector sourceDeviceManagementExchangeConnector) throws ClientException;

    /**
     * Posts a DeviceManagementExchangeConnector with a new object
     *
     * @param newDeviceManagementExchangeConnector the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceManagementExchangeConnector newDeviceManagementExchangeConnector, final ICallback<? super DeviceManagementExchangeConnector> callback);

    /**
     * Posts a DeviceManagementExchangeConnector with a new object
     *
     * @param newDeviceManagementExchangeConnector the new object to create
     * @return the created DeviceManagementExchangeConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceManagementExchangeConnector post(final DeviceManagementExchangeConnector newDeviceManagementExchangeConnector) throws ClientException;

    /**
     * Posts a DeviceManagementExchangeConnector with a new object
     *
     * @param newDeviceManagementExchangeConnector the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DeviceManagementExchangeConnector newDeviceManagementExchangeConnector, final ICallback<? super DeviceManagementExchangeConnector> callback);

    /**
     * Posts a DeviceManagementExchangeConnector with a new object
     *
     * @param newDeviceManagementExchangeConnector the object to create/update
     * @return the created DeviceManagementExchangeConnector
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceManagementExchangeConnector put(final DeviceManagementExchangeConnector newDeviceManagementExchangeConnector) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceManagementExchangeConnectorRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceManagementExchangeConnectorRequest expand(final String value);

}

