// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.ChatMessagePolicyViolationDlpActionTypes;
import com.microsoft.graph.models.extensions.ChatMessagePolicyViolationPolicyTip;
import com.microsoft.graph.models.generated.ChatMessagePolicyViolationUserActionTypes;
import com.microsoft.graph.models.generated.ChatMessagePolicyViolationVerdictDetailsTypes;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Chat Message Policy Violation.
 */
public class ChatMessagePolicyViolation implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Dlp Action.
     * The action taken by the DLP provider on the message with sensitive content. Supported values are: NoneNotifySender -- Inform the sender of the violation but allow readers to read the message.BlockAccess -- Block readers from reading the message.BlockAccessExternal -- Block users outside the organization from reading the message, while allowing users within the organization to read the message.
     */
    @SerializedName(value = "dlpAction", alternate = {"DlpAction"})
    @Expose
    public EnumSet<ChatMessagePolicyViolationDlpActionTypes> dlpAction;

    /**
     * The Justification Text.
     * Justification text provided by the sender of the message when overriding a policy violation.
     */
    @SerializedName(value = "justificationText", alternate = {"JustificationText"})
    @Expose
    public String justificationText;

    /**
     * The Policy Tip.
     * Information to display to the message sender about why the message was flagged as a violation.
     */
    @SerializedName(value = "policyTip", alternate = {"PolicyTip"})
    @Expose
    public ChatMessagePolicyViolationPolicyTip policyTip;

    /**
     * The User Action.
     * Indicates the action taken by the user on a message blocked by the DLP provider. Supported values are: NoneOverrideReportFalsePositiveWhen the DLP provider is updating the message for blocking sensitive content, userAction is not required.
     */
    @SerializedName(value = "userAction", alternate = {"UserAction"})
    @Expose
    public EnumSet<ChatMessagePolicyViolationUserActionTypes> userAction;

    /**
     * The Verdict Details.
     * Indicates what actions the sender may take in response to the policy violation. Supported values are: NoneAllowFalsePositiveOverride -- Allows the sender to declare the policyViolation to be an error in the DLP app and its rules, and allow readers to see the message again if the dlpAction had hidden it.AllowOverrideWithoutJustification -- Allows the sender to overriide the DLP violation and allow readers to see the message again if the dlpAction had hidden it, without needing to provide an explanation for doing so. AllowOverrideWithJustification -- Allows the sender to overriide the DLP violation and allow readers to see the message again if the dlpAction had hidden it, after providing an explanation for doing so.AllowOverrideWithoutJustification and AllowOverrideWithJustification are mutually exclusive.
     */
    @SerializedName(value = "verdictDetails", alternate = {"VerdictDetails"})
    @Expose
    public EnumSet<ChatMessagePolicyViolationVerdictDetailsTypes> verdictDetails;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
