// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.DeviceEnrollmentConfiguration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Device Enrollment Configuration Request.
 */
public interface IDeviceEnrollmentConfigurationRequest extends IHttpRequest {

    /**
     * Gets the DeviceEnrollmentConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super DeviceEnrollmentConfiguration> callback);

    /**
     * Gets the DeviceEnrollmentConfiguration from the service
     *
     * @return the DeviceEnrollmentConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceEnrollmentConfiguration get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super DeviceEnrollmentConfiguration> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this DeviceEnrollmentConfiguration with a source
     *
     * @param sourceDeviceEnrollmentConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final DeviceEnrollmentConfiguration sourceDeviceEnrollmentConfiguration, final ICallback<? super DeviceEnrollmentConfiguration> callback);

    /**
     * Patches this DeviceEnrollmentConfiguration with a source
     *
     * @param sourceDeviceEnrollmentConfiguration the source object with updates
     * @return the updated DeviceEnrollmentConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceEnrollmentConfiguration patch(final DeviceEnrollmentConfiguration sourceDeviceEnrollmentConfiguration) throws ClientException;

    /**
     * Posts a DeviceEnrollmentConfiguration with a new object
     *
     * @param newDeviceEnrollmentConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final DeviceEnrollmentConfiguration newDeviceEnrollmentConfiguration, final ICallback<? super DeviceEnrollmentConfiguration> callback);

    /**
     * Posts a DeviceEnrollmentConfiguration with a new object
     *
     * @param newDeviceEnrollmentConfiguration the new object to create
     * @return the created DeviceEnrollmentConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceEnrollmentConfiguration post(final DeviceEnrollmentConfiguration newDeviceEnrollmentConfiguration) throws ClientException;

    /**
     * Posts a DeviceEnrollmentConfiguration with a new object
     *
     * @param newDeviceEnrollmentConfiguration the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final DeviceEnrollmentConfiguration newDeviceEnrollmentConfiguration, final ICallback<? super DeviceEnrollmentConfiguration> callback);

    /**
     * Posts a DeviceEnrollmentConfiguration with a new object
     *
     * @param newDeviceEnrollmentConfiguration the object to create/update
     * @return the created DeviceEnrollmentConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    DeviceEnrollmentConfiguration put(final DeviceEnrollmentConfiguration newDeviceEnrollmentConfiguration) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IDeviceEnrollmentConfigurationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IDeviceEnrollmentConfigurationRequest expand(final String value);

}

