/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.CertificateBasedAuthConfiguration;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.CertificateBasedAuthConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.CertificateBasedAuthConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.CertificateBasedAuthConfigurationCollectionResponse;
import com.microsoft.graph.requests.extensions.CertificateBasedAuthConfigurationRequestBuilder;
import com.microsoft.graph.requests.extensions.ICertificateBasedAuthConfigurationCollectionPage;
import com.microsoft.graph.requests.extensions.ICertificateBasedAuthConfigurationCollectionRequest;
import java.util.List;

public class CertificateBasedAuthConfigurationCollectionRequest
extends BaseCollectionRequest<CertificateBasedAuthConfigurationCollectionResponse, ICertificateBasedAuthConfigurationCollectionPage>
implements ICertificateBasedAuthConfigurationCollectionRequest {
    public CertificateBasedAuthConfigurationCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, CertificateBasedAuthConfigurationCollectionResponse.class, ICertificateBasedAuthConfigurationCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super ICertificateBasedAuthConfigurationCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(CertificateBasedAuthConfigurationCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionPage get() throws ClientException {
        CertificateBasedAuthConfigurationCollectionResponse response = (CertificateBasedAuthConfigurationCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration, ICallback<? super CertificateBasedAuthConfiguration> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new CertificateBasedAuthConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCertificateBasedAuthConfiguration, callback);
    }

    @Override
    public CertificateBasedAuthConfiguration post(CertificateBasedAuthConfiguration newCertificateBasedAuthConfiguration) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new CertificateBasedAuthConfigurationRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newCertificateBasedAuthConfiguration);
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public ICertificateBasedAuthConfigurationCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public ICertificateBasedAuthConfigurationCollectionPage buildFromResponse(CertificateBasedAuthConfigurationCollectionResponse response) {
        CertificateBasedAuthConfigurationCollectionRequestBuilder builder = response.nextLink != null ? new CertificateBasedAuthConfigurationCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        CertificateBasedAuthConfigurationCollectionPage page = new CertificateBasedAuthConfigurationCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

