/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.models.extensions.LinkedResource;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.ILinkedResourceRequest;
import java.util.List;

public class LinkedResourceRequest
extends BaseRequest
implements ILinkedResourceRequest {
    public LinkedResourceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, LinkedResource.class);
    }

    @Override
    public void get(ICallback<? super LinkedResource> callback) {
        this.send(HttpMethod.GET, callback, null);
    }

    @Override
    public LinkedResource get() throws ClientException {
        return (LinkedResource)this.send(HttpMethod.GET, null);
    }

    @Override
    public void delete(ICallback<? super LinkedResource> callback) {
        this.send(HttpMethod.DELETE, callback, null);
    }

    @Override
    public void delete() throws ClientException {
        this.send(HttpMethod.DELETE, null);
    }

    @Override
    public void patch(LinkedResource sourceLinkedResource, ICallback<? super LinkedResource> callback) {
        this.send(HttpMethod.PATCH, callback, sourceLinkedResource);
    }

    @Override
    public LinkedResource patch(LinkedResource sourceLinkedResource) throws ClientException {
        return (LinkedResource)this.send(HttpMethod.PATCH, sourceLinkedResource);
    }

    @Override
    public void post(LinkedResource newLinkedResource, ICallback<? super LinkedResource> callback) {
        this.send(HttpMethod.POST, callback, newLinkedResource);
    }

    @Override
    public LinkedResource post(LinkedResource newLinkedResource) throws ClientException {
        return (LinkedResource)this.send(HttpMethod.POST, newLinkedResource);
    }

    @Override
    public void put(LinkedResource newLinkedResource, ICallback<? super LinkedResource> callback) {
        this.send(HttpMethod.PUT, callback, newLinkedResource);
    }

    @Override
    public LinkedResource put(LinkedResource newLinkedResource) throws ClientException {
        return (LinkedResource)this.send(HttpMethod.PUT, newLinkedResource);
    }

    @Override
    public ILinkedResourceRequest select(String value) {
        this.getQueryOptions().add(new QueryOption("$select", value));
        return this;
    }

    @Override
    public ILinkedResourceRequest expand(String value) {
        this.getQueryOptions().add(new QueryOption("$expand", value));
        return this;
    }
}

