/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.MdmWindowsInformationProtectionPolicy;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IMdmWindowsInformationProtectionPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.IMdmWindowsInformationProtectionPolicyCollectionRequest;
import com.microsoft.graph.requests.extensions.MdmWindowsInformationProtectionPolicyCollectionPage;
import com.microsoft.graph.requests.extensions.MdmWindowsInformationProtectionPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.MdmWindowsInformationProtectionPolicyCollectionResponse;
import com.microsoft.graph.requests.extensions.MdmWindowsInformationProtectionPolicyRequestBuilder;
import java.util.List;

public class MdmWindowsInformationProtectionPolicyCollectionRequest
extends BaseCollectionRequest<MdmWindowsInformationProtectionPolicyCollectionResponse, IMdmWindowsInformationProtectionPolicyCollectionPage>
implements IMdmWindowsInformationProtectionPolicyCollectionRequest {
    public MdmWindowsInformationProtectionPolicyCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, MdmWindowsInformationProtectionPolicyCollectionResponse.class, IMdmWindowsInformationProtectionPolicyCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IMdmWindowsInformationProtectionPolicyCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(MdmWindowsInformationProtectionPolicyCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IMdmWindowsInformationProtectionPolicyCollectionPage get() throws ClientException {
        MdmWindowsInformationProtectionPolicyCollectionResponse response = (MdmWindowsInformationProtectionPolicyCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(MdmWindowsInformationProtectionPolicy newMdmWindowsInformationProtectionPolicy, ICallback<? super MdmWindowsInformationProtectionPolicy> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new MdmWindowsInformationProtectionPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMdmWindowsInformationProtectionPolicy, callback);
    }

    @Override
    public MdmWindowsInformationProtectionPolicy post(MdmWindowsInformationProtectionPolicy newMdmWindowsInformationProtectionPolicy) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new MdmWindowsInformationProtectionPolicyRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newMdmWindowsInformationProtectionPolicy);
    }

    @Override
    public IMdmWindowsInformationProtectionPolicyCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IMdmWindowsInformationProtectionPolicyCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IMdmWindowsInformationProtectionPolicyCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IMdmWindowsInformationProtectionPolicyCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IMdmWindowsInformationProtectionPolicyCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IMdmWindowsInformationProtectionPolicyCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IMdmWindowsInformationProtectionPolicyCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IMdmWindowsInformationProtectionPolicyCollectionPage buildFromResponse(MdmWindowsInformationProtectionPolicyCollectionResponse response) {
        MdmWindowsInformationProtectionPolicyCollectionRequestBuilder builder = response.nextLink != null ? new MdmWindowsInformationProtectionPolicyCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        MdmWindowsInformationProtectionPolicyCollectionPage page = new MdmWindowsInformationProtectionPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

