/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.OpenShift;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IOpenShiftCollectionPage;
import com.microsoft.graph.requests.extensions.IOpenShiftCollectionRequest;
import com.microsoft.graph.requests.extensions.OpenShiftCollectionPage;
import com.microsoft.graph.requests.extensions.OpenShiftCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.OpenShiftCollectionResponse;
import com.microsoft.graph.requests.extensions.OpenShiftRequestBuilder;
import java.util.List;

public class OpenShiftCollectionRequest
extends BaseCollectionRequest<OpenShiftCollectionResponse, IOpenShiftCollectionPage>
implements IOpenShiftCollectionRequest {
    public OpenShiftCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OpenShiftCollectionResponse.class, IOpenShiftCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IOpenShiftCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(OpenShiftCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IOpenShiftCollectionPage get() throws ClientException {
        OpenShiftCollectionResponse response = (OpenShiftCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(OpenShift newOpenShift, ICallback<? super OpenShift> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new OpenShiftRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOpenShift, callback);
    }

    @Override
    public OpenShift post(OpenShift newOpenShift) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new OpenShiftRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newOpenShift);
    }

    @Override
    public IOpenShiftCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IOpenShiftCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IOpenShiftCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IOpenShiftCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IOpenShiftCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IOpenShiftCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IOpenShiftCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IOpenShiftCollectionPage buildFromResponse(OpenShiftCollectionResponse response) {
        OpenShiftCollectionRequestBuilder builder = response.nextLink != null ? new OpenShiftCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        OpenShiftCollectionPage page = new OpenShiftCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

