/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.models.extensions.ServicePrincipal;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IServicePrincipalCollectionPage;
import com.microsoft.graph.requests.extensions.IServicePrincipalCollectionReferenceRequest;
import com.microsoft.graph.requests.extensions.ServicePrincipalCollectionResponse;
import com.microsoft.graph.requests.extensions.ServicePrincipalWithReferenceRequestBuilder;
import java.util.List;

public class ServicePrincipalCollectionReferenceRequest
extends BaseCollectionRequest<ServicePrincipalCollectionResponse, IServicePrincipalCollectionPage>
implements IServicePrincipalCollectionReferenceRequest {
    public ServicePrincipalCollectionReferenceRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ServicePrincipalCollectionResponse.class, IServicePrincipalCollectionPage.class);
    }

    @Override
    public void post(ServicePrincipal newServicePrincipal, ICallback<? super ServicePrincipal> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/servicePrincipals/" + newServicePrincipal.id);
        new ServicePrincipalWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newServicePrincipal, body, callback);
    }

    @Override
    public ServicePrincipal post(ServicePrincipal newServicePrincipal) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/servicePrincipals/" + newServicePrincipal.id);
        return new ServicePrincipalWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newServicePrincipal, body);
    }

    public IServicePrincipalCollectionReferenceRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    public IServicePrincipalCollectionReferenceRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    public IServicePrincipalCollectionReferenceRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IServicePrincipalCollectionReferenceRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IServicePrincipalCollectionReferenceRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }
}

