/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.NotificationMessageTemplate;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.INotificationMessageTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.INotificationMessageTemplateCollectionRequest;
import com.microsoft.graph.requests.extensions.NotificationMessageTemplateCollectionPage;
import com.microsoft.graph.requests.extensions.NotificationMessageTemplateCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.NotificationMessageTemplateCollectionResponse;
import com.microsoft.graph.requests.extensions.NotificationMessageTemplateRequestBuilder;
import java.util.List;

public class NotificationMessageTemplateCollectionRequest
extends BaseCollectionRequest<NotificationMessageTemplateCollectionResponse, INotificationMessageTemplateCollectionPage>
implements INotificationMessageTemplateCollectionRequest {
    public NotificationMessageTemplateCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, NotificationMessageTemplateCollectionResponse.class, INotificationMessageTemplateCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super INotificationMessageTemplateCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(NotificationMessageTemplateCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public INotificationMessageTemplateCollectionPage get() throws ClientException {
        NotificationMessageTemplateCollectionResponse response = (NotificationMessageTemplateCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(NotificationMessageTemplate newNotificationMessageTemplate, ICallback<? super NotificationMessageTemplate> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new NotificationMessageTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newNotificationMessageTemplate, callback);
    }

    @Override
    public NotificationMessageTemplate post(NotificationMessageTemplate newNotificationMessageTemplate) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new NotificationMessageTemplateRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newNotificationMessageTemplate);
    }

    @Override
    public INotificationMessageTemplateCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public INotificationMessageTemplateCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public INotificationMessageTemplateCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public INotificationMessageTemplateCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public INotificationMessageTemplateCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public INotificationMessageTemplateCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public INotificationMessageTemplateCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public INotificationMessageTemplateCollectionPage buildFromResponse(NotificationMessageTemplateCollectionResponse response) {
        NotificationMessageTemplateCollectionRequestBuilder builder = response.nextLink != null ? new NotificationMessageTemplateCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        NotificationMessageTemplateCollectionPage page = new NotificationMessageTemplateCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

