/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.Presence;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.IPresenceCollectionPage;
import com.microsoft.graph.requests.extensions.IPresenceCollectionRequest;
import com.microsoft.graph.requests.extensions.PresenceCollectionPage;
import com.microsoft.graph.requests.extensions.PresenceCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.PresenceCollectionResponse;
import com.microsoft.graph.requests.extensions.PresenceRequestBuilder;
import java.util.List;

public class PresenceCollectionRequest
extends BaseCollectionRequest<PresenceCollectionResponse, IPresenceCollectionPage>
implements IPresenceCollectionRequest {
    public PresenceCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, PresenceCollectionResponse.class, IPresenceCollectionPage.class);
    }

    @Override
    public void get(final ICallback<? super IPresenceCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(PresenceCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IPresenceCollectionPage get() throws ClientException {
        PresenceCollectionResponse response = (PresenceCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(Presence newPresence, ICallback<? super Presence> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new PresenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPresence, callback);
    }

    @Override
    public Presence post(Presence newPresence) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new PresenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newPresence);
    }

    @Override
    public IPresenceCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IPresenceCollectionRequest filter(String value) {
        this.addQueryOption(new QueryOption("$filter", value));
        return this;
    }

    @Override
    public IPresenceCollectionRequest orderBy(String value) {
        this.addQueryOption(new QueryOption("$orderby", value));
        return this;
    }

    @Override
    public IPresenceCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IPresenceCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IPresenceCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IPresenceCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IPresenceCollectionPage buildFromResponse(PresenceCollectionResponse response) {
        PresenceCollectionRequestBuilder builder = response.nextLink != null ? new PresenceCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        PresenceCollectionPage page = new PresenceCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

