// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.InformationProtection;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Information Protection Request.
 */
public interface IInformationProtectionRequest extends IHttpRequest {

    /**
     * Gets the InformationProtection from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super InformationProtection> callback);

    /**
     * Gets the InformationProtection from the service
     *
     * @return the InformationProtection from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InformationProtection get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super InformationProtection> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this InformationProtection with a source
     *
     * @param sourceInformationProtection the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final InformationProtection sourceInformationProtection, final ICallback<? super InformationProtection> callback);

    /**
     * Patches this InformationProtection with a source
     *
     * @param sourceInformationProtection the source object with updates
     * @return the updated InformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InformationProtection patch(final InformationProtection sourceInformationProtection) throws ClientException;

    /**
     * Posts a InformationProtection with a new object
     *
     * @param newInformationProtection the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final InformationProtection newInformationProtection, final ICallback<? super InformationProtection> callback);

    /**
     * Posts a InformationProtection with a new object
     *
     * @param newInformationProtection the new object to create
     * @return the created InformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InformationProtection post(final InformationProtection newInformationProtection) throws ClientException;

    /**
     * Posts a InformationProtection with a new object
     *
     * @param newInformationProtection the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final InformationProtection newInformationProtection, final ICallback<? super InformationProtection> callback);

    /**
     * Posts a InformationProtection with a new object
     *
     * @param newInformationProtection the object to create/update
     * @return the created InformationProtection
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    InformationProtection put(final InformationProtection newInformationProtection) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IInformationProtectionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IInformationProtectionRequest expand(final String value);

}

