// Template Source: IBaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ScopedRoleMembership;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Scoped Role Membership Request.
 */
public interface IScopedRoleMembershipRequest extends IHttpRequest {

    /**
     * Gets the ScopedRoleMembership from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<? super ScopedRoleMembership> callback);

    /**
     * Gets the ScopedRoleMembership from the service
     *
     * @return the ScopedRoleMembership from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ScopedRoleMembership get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<? super ScopedRoleMembership> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ScopedRoleMembership with a source
     *
     * @param sourceScopedRoleMembership the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ScopedRoleMembership sourceScopedRoleMembership, final ICallback<? super ScopedRoleMembership> callback);

    /**
     * Patches this ScopedRoleMembership with a source
     *
     * @param sourceScopedRoleMembership the source object with updates
     * @return the updated ScopedRoleMembership
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ScopedRoleMembership patch(final ScopedRoleMembership sourceScopedRoleMembership) throws ClientException;

    /**
     * Posts a ScopedRoleMembership with a new object
     *
     * @param newScopedRoleMembership the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ScopedRoleMembership newScopedRoleMembership, final ICallback<? super ScopedRoleMembership> callback);

    /**
     * Posts a ScopedRoleMembership with a new object
     *
     * @param newScopedRoleMembership the new object to create
     * @return the created ScopedRoleMembership
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ScopedRoleMembership post(final ScopedRoleMembership newScopedRoleMembership) throws ClientException;

    /**
     * Posts a ScopedRoleMembership with a new object
     *
     * @param newScopedRoleMembership the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ScopedRoleMembership newScopedRoleMembership, final ICallback<? super ScopedRoleMembership> callback);

    /**
     * Posts a ScopedRoleMembership with a new object
     *
     * @param newScopedRoleMembership the object to create/update
     * @return the created ScopedRoleMembership
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ScopedRoleMembership put(final ScopedRoleMembership newScopedRoleMembership) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IScopedRoleMembershipRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IScopedRoleMembershipRequest expand(final String value);

}

