// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Todo;
import com.microsoft.graph.requests.extensions.ITodoTaskListCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ITodoTaskListRequestBuilder;
import com.microsoft.graph.requests.extensions.TodoTaskListCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.TodoTaskListRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Todo Request.
 */
public class TodoRequest extends BaseRequest implements ITodoRequest {
	
    /**
     * The request for the Todo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TodoRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Todo.class);
    }

    /**
     * Gets the Todo from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<? super Todo> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Todo from the service
     *
     * @return the Todo from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Todo get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<? super Todo> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Todo with a source
     *
     * @param sourceTodo the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Todo sourceTodo, final ICallback<? super Todo> callback) {
        send(HttpMethod.PATCH, callback, sourceTodo);
    }

    /**
     * Patches this Todo with a source
     *
     * @param sourceTodo the source object with updates
     * @return the updated Todo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Todo patch(final Todo sourceTodo) throws ClientException {
        return send(HttpMethod.PATCH, sourceTodo);
    }

    /**
     * Creates a Todo with a new object
     *
     * @param newTodo the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Todo newTodo, final ICallback<? super Todo> callback) {
        send(HttpMethod.POST, callback, newTodo);
    }

    /**
     * Creates a Todo with a new object
     *
     * @param newTodo the new object to create
     * @return the created Todo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Todo post(final Todo newTodo) throws ClientException {
        return send(HttpMethod.POST, newTodo);
    }

    /**
     * Creates a Todo with a new object
     *
     * @param newTodo the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final Todo newTodo, final ICallback<? super Todo> callback) {
        send(HttpMethod.PUT, callback, newTodo);
    }

    /**
     * Creates a Todo with a new object
     *
     * @param newTodo the object to create/update
     * @return the created Todo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Todo put(final Todo newTodo) throws ClientException {
        return send(HttpMethod.PUT, newTodo);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ITodoRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (TodoRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ITodoRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (TodoRequest)this;
     }

}

